/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.vectormaster.models;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Path;
import com.sdsmdg.harjot.vectormaster.enums.TintMode;
import com.sdsmdg.harjot.vectormaster.models.ClipPathModel;
import com.sdsmdg.harjot.vectormaster.models.GroupModel;
import com.sdsmdg.harjot.vectormaster.models.PathModel;
import java.util.ArrayList;

public class VectorModel {
    private String name;
    private float width;
    private float height;
    private float alpha = 1.0f;
    private boolean autoMirrored = false;
    private int tint = 0;
    private TintMode tintMode = TintMode.SCR_IN;
    private float viewportWidth;
    private float viewportHeight;
    private ArrayList<GroupModel> groupModels = new ArrayList();
    private ArrayList<PathModel> pathModels = new ArrayList();
    private ArrayList<ClipPathModel> clipPathModels = new ArrayList();
    private Path fullpath = new Path();
    private Matrix scaleMatrix;

    public void drawPaths(Canvas canvas) {
        for (ClipPathModel clipPathModel : this.clipPathModels) {
            canvas.clipPath(clipPathModel.getPath());
        }
        for (GroupModel groupModel : this.groupModels) {
            groupModel.drawPaths(canvas);
        }
        for (PathModel pathModel : this.pathModels) {
            if (pathModel.isFillAndStroke()) {
                pathModel.makeFillPaint();
                canvas.drawPath(pathModel.getPath(), pathModel.getPathPaint());
                pathModel.makeStrokePaint();
                canvas.drawPath(pathModel.getPath(), pathModel.getPathPaint());
                continue;
            }
            canvas.drawPath(pathModel.getPath(), pathModel.getPathPaint());
        }
    }

    public void scaleAllPaths(Matrix scaleMatrix) {
        this.scaleMatrix = scaleMatrix;
        for (GroupModel groupModel : this.groupModels) {
            groupModel.scaleAllPaths(scaleMatrix);
        }
        for (PathModel pathModel : this.pathModels) {
            pathModel.transform(scaleMatrix);
        }
        for (ClipPathModel clipPathModel : this.clipPathModels) {
            clipPathModel.getPath().transform(scaleMatrix);
        }
    }

    public void scaleAllStrokeWidth(float ratio) {
        for (GroupModel groupModel : this.groupModels) {
            groupModel.scaleAllStrokeWidth(ratio);
        }
        for (PathModel pathModel : this.pathModels) {
            pathModel.setStrokeRatio(ratio);
        }
    }

    public void buildTransformMatrices() {
        for (GroupModel groupModel : this.groupModels) {
            groupModel.buildTransformMatrix();
        }
    }

    public void addGroupModel(GroupModel groupModel) {
        this.groupModels.add(groupModel);
    }

    public ArrayList<GroupModel> getGroupModels() {
        return this.groupModels;
    }

    public void addPathModel(PathModel pathModel) {
        this.pathModels.add(pathModel);
    }

    public ArrayList<PathModel> getPathModels() {
        return this.pathModels;
    }

    public void addClipPathModel(ClipPathModel clipPathModel) {
        this.clipPathModels.add(clipPathModel);
    }

    public ArrayList<ClipPathModel> getClipPathModels() {
        return this.clipPathModels;
    }

    public Path getFullpath() {
        return this.fullpath;
    }

    public void setFullpath(Path fullpath) {
        this.fullpath = fullpath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public boolean isAutoMirrored() {
        return this.autoMirrored;
    }

    public void setAutoMirrored(boolean autoMirrored) {
        this.autoMirrored = autoMirrored;
    }

    public int getTint() {
        return this.tint;
    }

    public void setTint(int tint) {
        this.tint = tint;
    }

    public TintMode getTintMode() {
        return this.tintMode;
    }

    public void setTintMode(TintMode tintMode) {
        this.tintMode = tintMode;
    }

    public float getViewportWidth() {
        return this.viewportWidth;
    }

    public void setViewportWidth(float viewportWidth) {
        this.viewportWidth = viewportWidth;
    }

    public float getViewportHeight() {
        return this.viewportHeight;
    }

    public void setViewportHeight(float viewportHeight) {
        this.viewportHeight = viewportHeight;
    }
}

