/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.rotatingtext;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.sdsmdg.harjot.rotatingtext.RotatingTextSwitcher;
import com.sdsmdg.harjot.rotatingtext.models.Rotatable;
import com.sdsmdg.harjot.rotatingtext.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RotatingTextWrapper
extends RelativeLayout {
    String text;
    ArrayList<Rotatable> rotatableList;
    boolean isContentSet = false;
    Context context;
    RelativeLayout.LayoutParams lp;
    int prevId;
    Typeface typeface;
    int size = 24;
    List<RotatingTextSwitcher> switcherList;

    public RotatingTextWrapper(Context context) {
        super(context);
        this.context = context;
    }

    public RotatingTextWrapper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public RotatingTextWrapper(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
    }

    public void setContent(String text, Rotatable ... rotatables) {
        this.text = text;
        this.rotatableList = new ArrayList();
        this.switcherList = new ArrayList<RotatingTextSwitcher>();
        Collections.addAll(this.rotatableList, rotatables);
        this.isContentSet = true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.isContentSet) {
            String[] array = this.text.split("\\?");
            if (array.length == 0) {
                RotatingTextSwitcher textSwitcher = new RotatingTextSwitcher(this.context);
                this.switcherList.add(textSwitcher);
                textSwitcher.setRotatable(this.rotatableList.get(0));
                if (Build.VERSION.SDK_INT < 17) {
                    textSwitcher.setId(Utils.generateViewId());
                } else {
                    textSwitcher.setId(View.generateViewId());
                }
                this.prevId = textSwitcher.getId();
                this.lp = new RelativeLayout.LayoutParams(-2, -2);
                this.lp.addRule(15);
                this.lp.addRule(9);
                this.addView((View)textSwitcher, (ViewGroup.LayoutParams)this.lp);
            }
            for (int i = 0; i < array.length; ++i) {
                TextView textView = new TextView(this.context);
                RotatingTextSwitcher textSwitcher = new RotatingTextSwitcher(this.context);
                this.switcherList.add(textSwitcher);
                textView.setText((CharSequence)array[i]);
                if (Build.VERSION.SDK_INT < 17) {
                    textView.setId(Utils.generateViewId());
                } else {
                    textView.setId(View.generateViewId());
                }
                textView.setTextSize((float)this.size);
                if (this.typeface != null) {
                    textView.setTypeface(this.typeface);
                }
                this.lp = new RelativeLayout.LayoutParams(-2, -2);
                this.lp.addRule(15);
                if (i == 0) {
                    this.lp.addRule(9);
                } else {
                    this.lp.addRule(1, this.prevId);
                }
                this.addView((View)textView, (ViewGroup.LayoutParams)this.lp);
                if (i >= this.rotatableList.size()) continue;
                textSwitcher.setRotatable(this.rotatableList.get(i));
                if (Build.VERSION.SDK_INT < 17) {
                    textSwitcher.setId(Utils.generateViewId());
                } else {
                    textSwitcher.setId(View.generateViewId());
                }
                this.prevId = textSwitcher.getId();
                this.lp = new RelativeLayout.LayoutParams(-2, -2);
                this.lp.addRule(15);
                this.lp.addRule(1, textView.getId());
                this.addView((View)textSwitcher, (ViewGroup.LayoutParams)this.lp);
            }
            this.isContentSet = false;
        }
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void pause(int position) {
        this.switcherList.get(position).pause();
    }

    public void resume(int position) {
        this.switcherList.get(position).resume();
    }
}

