/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.rotatingtext.models;

import android.graphics.Path;
import android.graphics.Typeface;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;

public class Rotatable {
    private int color = -16777216;
    private String[] text;
    private int updateDuration = 2000;
    private int animationDuration = 1000;
    private int currentWordNumber;
    private float size = 24.0f;
    private int strokeWidth = -1;
    private Path pathIn;
    private Path pathOut;
    private Interpolator interpolator = new LinearInterpolator();
    private Typeface typeface;
    private boolean isCenter = false;
    private boolean isUpdated = false;

    public Rotatable(int updateDuration, String ... text) {
        this.updateDuration = updateDuration;
        this.text = text;
        this.currentWordNumber = -1;
    }

    public Rotatable(int color, int updateDuration, String ... text) {
        this.color = color;
        this.updateDuration = updateDuration;
        this.text = text;
        this.currentWordNumber = -1;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.setUpdated(true);
    }

    public String[] getText() {
        return this.text;
    }

    public void setText(String ... text) {
        this.text = text;
    }

    public int getUpdateDuration() {
        return this.updateDuration;
    }

    public void setUpdateDuration(int updateDuration) {
        this.updateDuration = updateDuration;
        this.setUpdated(true);
    }

    public int getNextWordNumber() {
        this.currentWordNumber = (this.currentWordNumber + 1) % this.text.length;
        return this.currentWordNumber;
    }

    public String peekNextWord() {
        return this.text[(this.currentWordNumber + 1) % this.text.length];
    }

    public String getNextWord() {
        return this.text[this.getNextWordNumber()];
    }

    public String getPreviousWord() {
        if (this.currentWordNumber <= 0) {
            return this.text[this.text.length - 1];
        }
        return this.text[this.currentWordNumber - 1];
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
        this.setUpdated(true);
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
        this.setUpdated(true);
    }

    public Path getPathIn() {
        return this.pathIn;
    }

    public void setPathIn(Path pathIn) {
        this.pathIn = pathIn;
    }

    public Path getPathOut() {
        return this.pathOut;
    }

    public void setPathOut(Path pathOut) {
        this.pathOut = pathOut;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        this.setUpdated(true);
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
        this.setUpdated(true);
    }

    public String getLargestWord() {
        String largest = "";
        for (String s : this.text) {
            if (s.length() <= largest.length()) continue;
            largest = s;
        }
        return largest + " ";
    }

    public boolean isCenter() {
        return this.isCenter;
    }

    public void setCenter(boolean center) {
        this.isCenter = center;
        this.setUpdated(true);
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public void setUpdated(boolean updated) {
        this.isUpdated = updated;
    }
}

