/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.rotatingtext;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.widget.TextView;
import com.sdsmdg.harjot.rotatingtext.models.Rotatable;
import java.util.Timer;
import java.util.TimerTask;

public class RotatingTextSwitcher
extends TextView {
    Context context;
    Rotatable rotatable;
    Paint paint;
    float density;
    boolean isRotatableSet = false;
    Path pathIn;
    Path pathOut;
    Timer updateWordTimer;
    Timer renderTimer;
    String currentText = "";
    boolean isPaused = false;

    public RotatingTextSwitcher(Context context) {
        super(context);
        this.context = context;
    }

    public void setRotatable(Rotatable rotatable) {
        this.rotatable = rotatable;
        this.isRotatableSet = true;
        this.init();
    }

    void init() {
        this.paint = this.getPaint();
        this.density = this.getContext().getResources().getDisplayMetrics().density;
        this.paint.setAntiAlias(true);
        this.paint.setTextSize(this.rotatable.getSize() * this.density);
        this.paint.setColor(this.rotatable.getColor());
        if (this.rotatable.isCenter()) {
            this.paint.setTextAlign(Paint.Align.CENTER);
        }
        if (this.rotatable.getTypeface() != null) {
            this.paint.setTypeface(this.rotatable.getTypeface());
        }
        this.setText(this.rotatable.getLargestWord());
        this.currentText = this.rotatable.getNextWord();
        this.post(new Runnable(){

            @Override
            public void run() {
                RotatingTextSwitcher.this.pathIn = new Path();
                RotatingTextSwitcher.this.pathIn.moveTo(0.0f, (float)RotatingTextSwitcher.this.getHeight() - RotatingTextSwitcher.this.paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.pathIn.lineTo((float)RotatingTextSwitcher.this.getWidth(), (float)RotatingTextSwitcher.this.getHeight() - RotatingTextSwitcher.this.paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.rotatable.setPathIn(RotatingTextSwitcher.this.pathIn);
                RotatingTextSwitcher.this.pathOut = new Path();
                RotatingTextSwitcher.this.pathOut.moveTo(0.0f, (float)(2 * RotatingTextSwitcher.this.getHeight()) - RotatingTextSwitcher.this.paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.pathOut.lineTo((float)RotatingTextSwitcher.this.getWidth(), (float)(2 * RotatingTextSwitcher.this.getHeight()) - RotatingTextSwitcher.this.paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.rotatable.setPathOut(RotatingTextSwitcher.this.pathOut);
            }
        });
        this.renderTimer = new Timer();
        this.renderTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)RotatingTextSwitcher.this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        RotatingTextSwitcher.this.invalidate();
                    }
                });
            }
        }, 0L, 16L);
        this.updateWordTimer = new Timer();
        this.updateWordTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)RotatingTextSwitcher.this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (RotatingTextSwitcher.this.isPaused) {
                            RotatingTextSwitcher.this.pauseRender();
                        } else {
                            RotatingTextSwitcher.this.resumeRender();
                            RotatingTextSwitcher.this.animateInHorizontal();
                            RotatingTextSwitcher.this.animateOutHorizontal();
                            RotatingTextSwitcher.this.currentText = RotatingTextSwitcher.this.rotatable.getNextWord();
                        }
                    }
                });
            }
        }, this.rotatable.getUpdateDuration(), (long)this.rotatable.getUpdateDuration());
    }

    protected void onDraw(Canvas canvas) {
        if (this.isRotatableSet) {
            if (this.rotatable.isUpdated()) {
                this.updatePaint();
                this.rotatable.setUpdated(false);
            }
            String text = this.currentText;
            if (this.rotatable.getPathIn() != null) {
                canvas.drawTextOnPath(text, this.rotatable.getPathIn(), 0.0f, 0.0f, this.paint);
            }
            if (this.rotatable.getPathOut() != null) {
                canvas.drawTextOnPath(this.rotatable.getPreviousWord(), this.rotatable.getPathOut(), 0.0f, 0.0f, this.paint);
            }
        }
    }

    void animateInHorizontal() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.getHeight()});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                RotatingTextSwitcher.this.pathIn = new Path();
                RotatingTextSwitcher.this.pathIn.moveTo(0.0f, ((Float)valueAnimator.getAnimatedValue()).floatValue() - RotatingTextSwitcher.this.paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.pathIn.lineTo((float)RotatingTextSwitcher.this.getWidth(), ((Float)valueAnimator.getAnimatedValue()).floatValue() - RotatingTextSwitcher.this.paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.rotatable.setPathIn(RotatingTextSwitcher.this.pathIn);
            }
        });
        animator.setInterpolator((TimeInterpolator)this.rotatable.getInterpolator());
        animator.setDuration((long)this.rotatable.getAnimationDuration());
        animator.start();
    }

    void animateOutHorizontal() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.getHeight(), (float)this.getHeight() * 2.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                RotatingTextSwitcher.this.pathOut = new Path();
                RotatingTextSwitcher.this.pathOut.moveTo(0.0f, ((Float)valueAnimator.getAnimatedValue()).floatValue() - RotatingTextSwitcher.this.paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.pathOut.lineTo((float)RotatingTextSwitcher.this.getWidth(), ((Float)valueAnimator.getAnimatedValue()).floatValue() - RotatingTextSwitcher.this.paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.rotatable.setPathOut(RotatingTextSwitcher.this.pathOut);
            }
        });
        animator.setInterpolator((TimeInterpolator)this.rotatable.getInterpolator());
        animator.setDuration((long)this.rotatable.getAnimationDuration());
        animator.start();
    }

    void animateInCurve() {
        final int stringLength = this.rotatable.peekNextWord().length();
        final float[] yValues = new float[stringLength];
        for (int i = 0; i < stringLength; ++i) {
            yValues[i] = 0.0f;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.getHeight()});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int i;
                yValues[0] = ((Float)valueAnimator.getAnimatedValue()).floatValue() - RotatingTextSwitcher.this.paint.getFontMetrics().bottom;
                for (i = 1; i < stringLength; ++i) {
                    if (!(valueAnimator.getAnimatedFraction() > (float)i / (float)stringLength)) continue;
                    yValues[i] = (valueAnimator.getAnimatedFraction() - (float)i / (float)stringLength) * yValues[0];
                }
                RotatingTextSwitcher.this.pathIn = new Path();
                RotatingTextSwitcher.this.pathIn.moveTo(0.0f, yValues[0]);
                for (i = 1; i < stringLength; ++i) {
                    RotatingTextSwitcher.this.pathIn.lineTo((float)RotatingTextSwitcher.this.getWidth() * ((float)i / (float)stringLength), yValues[i]);
                    RotatingTextSwitcher.this.pathIn.moveTo((float)RotatingTextSwitcher.this.getWidth() * ((float)i / (float)stringLength), yValues[i]);
                }
                RotatingTextSwitcher.this.rotatable.setPathIn(RotatingTextSwitcher.this.pathIn);
            }
        });
        animator.setInterpolator((TimeInterpolator)this.rotatable.getInterpolator());
        animator.setDuration((long)this.rotatable.getAnimationDuration());
        animator.start();
    }

    void animateOutCurve() {
        final int stringLength = this.getText().length();
        final float[] yValues = new float[stringLength];
        for (int i = 0; i < stringLength; ++i) {
            yValues[i] = this.getHeight();
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.getHeight(), 2 * this.getHeight()});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int i;
                yValues[0] = ((Float)valueAnimator.getAnimatedValue()).floatValue() - RotatingTextSwitcher.this.paint.getFontMetrics().bottom;
                for (i = 1; i < stringLength; ++i) {
                    if (!(valueAnimator.getAnimatedFraction() > (float)i / (float)stringLength)) continue;
                    yValues[i] = (valueAnimator.getAnimatedFraction() - (float)i / (float)stringLength) * yValues[0];
                }
                RotatingTextSwitcher.this.pathIn = new Path();
                RotatingTextSwitcher.this.pathIn.moveTo(0.0f, yValues[0]);
                for (i = 1; i < stringLength; ++i) {
                    RotatingTextSwitcher.this.pathIn.lineTo((float)RotatingTextSwitcher.this.getWidth() * ((float)i / (float)stringLength), yValues[i]);
                    RotatingTextSwitcher.this.pathIn.moveTo((float)RotatingTextSwitcher.this.getWidth() * ((float)i / (float)stringLength), yValues[i]);
                }
                RotatingTextSwitcher.this.rotatable.setPathIn(RotatingTextSwitcher.this.pathIn);
            }
        });
        animator.setInterpolator((TimeInterpolator)this.rotatable.getInterpolator());
        animator.setDuration((long)this.rotatable.getAnimationDuration());
        animator.start();
    }

    void pause() {
        this.isPaused = true;
    }

    void resume() {
        this.isPaused = false;
    }

    void pauseRender() {
        this.renderTimer.cancel();
    }

    void resumeRender() {
        this.renderTimer = new Timer();
        this.renderTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)RotatingTextSwitcher.this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        RotatingTextSwitcher.this.invalidate();
                    }
                });
            }
        }, 0L, 16L);
    }

    void updatePaint() {
        this.paint.setTextSize(this.rotatable.getSize() * this.density);
        this.paint.setColor(this.rotatable.getColor());
        if (this.rotatable.isCenter()) {
            this.paint.setTextAlign(Paint.Align.CENTER);
        }
        if (this.rotatable.getTypeface() != null) {
            this.paint.setTypeface(this.rotatable.getTypeface());
        }
        if (this.updateWordTimer != null) {
            this.updateWordTimer.cancel();
        }
        this.updateWordTimer = new Timer();
        this.updateWordTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)RotatingTextSwitcher.this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (RotatingTextSwitcher.this.isPaused) {
                            RotatingTextSwitcher.this.pauseRender();
                        } else {
                            RotatingTextSwitcher.this.resumeRender();
                            RotatingTextSwitcher.this.animateInHorizontal();
                            RotatingTextSwitcher.this.animateOutHorizontal();
                            RotatingTextSwitcher.this.currentText = RotatingTextSwitcher.this.rotatable.getNextWord();
                        }
                    }
                });
            }
        }, this.rotatable.getUpdateDuration(), (long)this.rotatable.getUpdateDuration());
    }
}

