/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.crollerTest;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.sdsmdg.harjot.croller.R;

public class Croller
extends View {
    private float midx;
    private float midy;
    private Paint textPaint;
    private Paint circlePaint;
    private Paint circlePaint2;
    private Paint linePaint;
    private float currdeg = 0.0f;
    private float deg = 3.0f;
    private float downdeg = 0.0f;
    private boolean isContinuous = false;
    private int backCircleColor = Color.parseColor((String)"#222222");
    private int mainCircleColor = Color.parseColor((String)"#000000");
    private int indicatorColor = Color.parseColor((String)"#FFA036");
    private int progressPrimaryColor = Color.parseColor((String)"#FFA036");
    private int progressSecondaryColor = Color.parseColor((String)"#111111");
    private float progressPrimaryCircleSize = -1.0f;
    private float progressSecondaryCircleSize = -1.0f;
    private float progressPrimaryStrokeWidth = 25.0f;
    private float progressSecondaryStrokeWidth = 10.0f;
    private float mainCircleRadius = -1.0f;
    private float backCircleRadius = -1.0f;
    private float progressRadius = -1.0f;
    private int max = 25;
    private float indicatorWidth = 7.0f;
    private String label = "Label";
    private int labelSize = 40;
    private int labelColor = -1;
    private int startOffset = 30;
    private int startOffset2 = 0;
    private int sweepAngle = -1;
    RectF oval;
    private onProgressChangedListener mListener;

    public void setOnProgressChangedListener(onProgressChangedListener listener) {
        this.mListener = listener;
    }

    public Croller(Context context) {
        super(context);
        this.init();
    }

    public Croller(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initXMLAttrs(context, attrs);
        this.init();
    }

    public Croller(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initXMLAttrs(context, attrs);
        this.init();
    }

    private void init() {
        this.textPaint = new Paint();
        this.textPaint.setColor(this.labelColor);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setTextSize((float)this.labelSize);
        this.textPaint.setFakeBoldText(true);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.circlePaint = new Paint();
        this.circlePaint.setColor(this.progressSecondaryColor);
        this.circlePaint.setStrokeWidth(this.progressSecondaryStrokeWidth);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint2 = new Paint();
        this.circlePaint2.setColor(this.progressPrimaryColor);
        this.circlePaint2.setStrokeWidth(this.progressPrimaryStrokeWidth);
        this.circlePaint2.setStyle(Paint.Style.FILL);
        this.linePaint = new Paint();
        this.linePaint.setColor(this.indicatorColor);
        this.linePaint.setStrokeWidth(this.indicatorWidth);
        this.oval = new RectF();
    }

    private void initXMLAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Croller);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.Croller_progress) {
                this.setProgress(a.getInt(attr, 1));
                continue;
            }
            if (attr == R.styleable.Croller_label) {
                this.setLabel(a.getString(attr));
                continue;
            }
            if (attr == R.styleable.Croller_back_circle_color) {
                this.setBackCircleColor(a.getColor(attr, Color.parseColor((String)"#222222")));
                continue;
            }
            if (attr == R.styleable.Croller_main_circle_color) {
                this.setMainCircleColor(a.getColor(attr, Color.parseColor((String)"#000000")));
                continue;
            }
            if (attr == R.styleable.Croller_indicator_color) {
                this.setIndicatorColor(a.getColor(attr, Color.parseColor((String)"#FFA036")));
                continue;
            }
            if (attr == R.styleable.Croller_progress_primary_color) {
                this.setProgressPrimaryColor(a.getColor(attr, Color.parseColor((String)"#FFA036")));
                continue;
            }
            if (attr == R.styleable.Croller_progress_secondary_color) {
                this.setProgressSecondaryColor(a.getColor(attr, Color.parseColor((String)"#111111")));
                continue;
            }
            if (attr == R.styleable.Croller_label_size) {
                this.setLabelSize(a.getInteger(attr, 40));
                continue;
            }
            if (attr == R.styleable.Croller_label_color) {
                this.setLabelColor(a.getColor(attr, -1));
                continue;
            }
            if (attr == R.styleable.Croller_indicator_width) {
                this.setIndicatorWidth(a.getFloat(attr, 7.0f));
                continue;
            }
            if (attr == R.styleable.Croller_is_continuous) {
                this.setIsContinuous(a.getBoolean(attr, false));
                continue;
            }
            if (attr == R.styleable.Croller_progress_primary_circle_size) {
                this.setProgressPrimaryCircleSize(a.getFloat(attr, -1.0f));
                continue;
            }
            if (attr == R.styleable.Croller_progress_secondary_circle_size) {
                this.setProgressSecondaryCircleSize(a.getFloat(attr, -1.0f));
                continue;
            }
            if (attr == R.styleable.Croller_progress_primary_stroke_width) {
                this.setProgressPrimaryStrokeWidth(a.getFloat(attr, 25.0f));
                continue;
            }
            if (attr == R.styleable.Croller_progress_secondary_stroke_width) {
                this.setProgressSecondaryStrokeWidth(a.getFloat(attr, 10.0f));
                continue;
            }
            if (attr == R.styleable.Croller_sweep_angle) {
                this.setSweepAngle(a.getInt(attr, -1));
                continue;
            }
            if (attr == R.styleable.Croller_start_offset) {
                this.setStartOffset(a.getInt(attr, 30));
                continue;
            }
            if (attr == R.styleable.Croller_max) {
                this.setMax(a.getInt(attr, 25));
                continue;
            }
            if (attr == R.styleable.Croller_main_circle_radius) {
                this.setMainCircleRadius(a.getFloat(attr, -1.0f));
                continue;
            }
            if (attr == R.styleable.Croller_back_circle_radius) {
                this.setBackCircleRadius(a.getFloat(attr, -1.0f));
                continue;
            }
            if (attr != R.styleable.Croller_progress_radius) continue;
            this.setProgressRadius(a.getFloat(attr, -1.0f));
        }
        a.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mListener != null) {
            this.mListener.onProgressChanged((int)(this.deg - 2.0f));
        }
        this.midx = canvas.getWidth() / 2;
        this.midy = canvas.getHeight() / 2;
        if (!this.isContinuous) {
            float y;
            float x;
            float tmp;
            int i;
            this.startOffset2 = this.startOffset - 15;
            this.circlePaint.setColor(this.progressSecondaryColor);
            this.circlePaint2.setColor(this.progressPrimaryColor);
            this.linePaint.setStrokeWidth(this.indicatorWidth);
            this.linePaint.setColor(this.indicatorColor);
            this.textPaint.setColor(this.labelColor);
            this.textPaint.setTextSize((float)this.labelSize);
            int radius = (int)(Math.min(this.midx, this.midy) * 0.90625f);
            if (this.sweepAngle == -1) {
                this.sweepAngle = 360 - 2 * this.startOffset2;
            }
            if (this.mainCircleRadius == -1.0f) {
                this.mainCircleRadius = (float)radius * 0.73333335f;
            }
            if (this.backCircleRadius == -1.0f) {
                this.backCircleRadius = (float)radius * 0.8666667f;
            }
            if (this.progressRadius == -1.0f) {
                this.progressRadius = radius;
            }
            float deg2 = Math.max(3.0f, this.deg);
            float deg3 = Math.min(this.deg, (float)(this.max + 2));
            for (i = (int)deg2; i < this.max + 3; ++i) {
                tmp = (float)this.startOffset2 / 360.0f + (float)this.sweepAngle / 360.0f * (float)i / (float)(this.max + 5);
                x = this.midx + (float)((double)this.progressRadius * Math.sin(Math.PI * 2 * (1.0 - (double)tmp)));
                y = this.midy + (float)((double)this.progressRadius * Math.cos(Math.PI * 2 * (1.0 - (double)tmp)));
                this.circlePaint.setColor(this.progressSecondaryColor);
                if (this.progressSecondaryCircleSize == -1.0f) {
                    canvas.drawCircle(x, y, (float)radius / 30.0f * (20.0f / (float)this.max) * ((float)this.sweepAngle / 270.0f), this.circlePaint);
                    continue;
                }
                canvas.drawCircle(x, y, this.progressSecondaryCircleSize, this.circlePaint);
            }
            i = 3;
            while ((float)i <= deg3) {
                tmp = (float)this.startOffset2 / 360.0f + (float)this.sweepAngle / 360.0f * (float)i / (float)(this.max + 5);
                x = this.midx + (float)((double)this.progressRadius * Math.sin(Math.PI * 2 * (1.0 - (double)tmp)));
                y = this.midy + (float)((double)this.progressRadius * Math.cos(Math.PI * 2 * (1.0 - (double)tmp)));
                if (this.progressPrimaryCircleSize == -1.0f) {
                    canvas.drawCircle(x, y, this.progressRadius / 15.0f * (20.0f / (float)this.max) * ((float)this.sweepAngle / 270.0f), this.circlePaint2);
                } else {
                    canvas.drawCircle(x, y, this.progressPrimaryCircleSize, this.circlePaint2);
                }
                ++i;
            }
            float tmp2 = (float)this.startOffset2 / 360.0f + (float)this.sweepAngle / 360.0f * this.deg / (float)(this.max + 5);
            float x1 = this.midx + (float)((double)((float)radius * 0.4f) * Math.sin(Math.PI * 2 * (1.0 - (double)tmp2)));
            float y1 = this.midy + (float)((double)((float)radius * 0.4f) * Math.cos(Math.PI * 2 * (1.0 - (double)tmp2)));
            float x2 = this.midx + (float)((double)((float)radius * 0.6f) * Math.sin(Math.PI * 2 * (1.0 - (double)tmp2)));
            float y2 = this.midy + (float)((double)((float)radius * 0.6f) * Math.cos(Math.PI * 2 * (1.0 - (double)tmp2)));
            this.circlePaint.setColor(this.backCircleColor);
            canvas.drawCircle(this.midx, this.midy, this.backCircleRadius, this.circlePaint);
            this.circlePaint.setColor(this.mainCircleColor);
            canvas.drawCircle(this.midx, this.midy, this.mainCircleRadius, this.circlePaint);
            canvas.drawText(this.label, this.midx, this.midy + (float)((double)radius * 1.1), this.textPaint);
            canvas.drawLine(x1, y1, x2, y2, this.linePaint);
        } else {
            int radius = (int)(Math.min(this.midx, this.midy) * 0.90625f);
            if (this.sweepAngle == -1) {
                this.sweepAngle = 360 - 2 * this.startOffset;
            }
            if (this.mainCircleRadius == -1.0f) {
                this.mainCircleRadius = (float)radius * 0.73333335f;
            }
            if (this.backCircleRadius == -1.0f) {
                this.backCircleRadius = (float)radius * 0.8666667f;
            }
            if (this.progressRadius == -1.0f) {
                this.progressRadius = radius;
            }
            this.circlePaint.setColor(this.progressSecondaryColor);
            this.circlePaint.setStrokeWidth(this.progressSecondaryStrokeWidth);
            this.circlePaint.setStyle(Paint.Style.STROKE);
            this.circlePaint2.setColor(this.progressPrimaryColor);
            this.circlePaint2.setStrokeWidth(this.progressPrimaryStrokeWidth);
            this.circlePaint2.setStyle(Paint.Style.STROKE);
            this.linePaint.setStrokeWidth(this.indicatorWidth);
            this.linePaint.setColor(this.indicatorColor);
            this.textPaint.setColor(this.labelColor);
            this.textPaint.setTextSize((float)this.labelSize);
            float deg3 = Math.min(this.deg, (float)(this.max + 2));
            this.oval.set(this.midx - this.progressRadius, this.midy - this.progressRadius, this.midx + this.progressRadius, this.midy + this.progressRadius);
            canvas.drawArc(this.oval, 90.0f + (float)this.startOffset, (float)this.sweepAngle, false, this.circlePaint);
            canvas.drawArc(this.oval, 90.0f + (float)this.startOffset, (deg3 - 2.0f) * ((float)this.sweepAngle / (float)this.max), false, this.circlePaint2);
            float tmp2 = (float)this.startOffset / 360.0f + (float)this.sweepAngle / 360.0f * ((this.deg - 2.0f) / (float)this.max);
            float x1 = this.midx + (float)((double)((float)radius * 0.4f) * Math.sin(Math.PI * 2 * (1.0 - (double)tmp2)));
            float y1 = this.midy + (float)((double)((float)radius * 0.4f) * Math.cos(Math.PI * 2 * (1.0 - (double)tmp2)));
            float x2 = this.midx + (float)((double)((float)radius * 0.6f) * Math.sin(Math.PI * 2 * (1.0 - (double)tmp2)));
            float y2 = this.midy + (float)((double)((float)radius * 0.6f) * Math.cos(Math.PI * 2 * (1.0 - (double)tmp2)));
            this.circlePaint.setStyle(Paint.Style.FILL);
            this.circlePaint.setColor(this.backCircleColor);
            canvas.drawCircle(this.midx, this.midy, this.backCircleRadius, this.circlePaint);
            this.circlePaint.setColor(this.mainCircleColor);
            canvas.drawCircle(this.midx, this.midy, this.mainCircleRadius, this.circlePaint);
            canvas.drawText(this.label, this.midx, this.midy + (float)((double)radius * 1.1), this.textPaint);
            canvas.drawLine(x1, y1, x2, y2, this.linePaint);
        }
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (e.getAction() == 0) {
            float dx = e.getX() - this.midx;
            float dy = e.getY() - this.midy;
            this.downdeg = (float)(Math.atan2(dy, dx) * 180.0 / Math.PI);
            this.downdeg -= 90.0f;
            if (this.downdeg < 0.0f) {
                this.downdeg += 360.0f;
            }
            this.downdeg = (float)Math.floor(this.downdeg / 360.0f * (float)(this.max + 5));
            return true;
        }
        if (e.getAction() == 2) {
            float dx = e.getX() - this.midx;
            float dy = e.getY() - this.midy;
            this.currdeg = (float)(Math.atan2(dy, dx) * 180.0 / Math.PI);
            this.currdeg -= 90.0f;
            if (this.currdeg < 0.0f) {
                this.currdeg += 360.0f;
            }
            this.currdeg = (float)Math.floor(this.currdeg / 360.0f * (float)(this.max + 5));
            if (this.currdeg / (float)(this.max + 4) > 0.75f && (this.downdeg - 0.0f) / (float)(this.max + 4) < 0.25f) {
                this.deg -= 1.0f;
                if (this.deg < 3.0f) {
                    this.deg = 3.0f;
                }
                this.downdeg = this.currdeg;
            } else if (this.downdeg / (float)(this.max + 4) > 0.75f && (this.currdeg - 0.0f) / (float)(this.max + 4) < 0.25f) {
                this.deg += 1.0f;
                if (this.deg > (float)(this.max + 2)) {
                    this.deg = this.max + 2;
                }
                this.downdeg = this.currdeg;
            } else {
                this.deg += this.currdeg - this.downdeg;
                if (this.deg > (float)(this.max + 2)) {
                    this.deg = this.max + 2;
                }
                if (this.deg < 3.0f) {
                    this.deg = 3.0f;
                }
                this.downdeg = this.currdeg;
            }
            this.invalidate();
            return true;
        }
        if (e.getAction() == 1) {
            return true;
        }
        return super.onTouchEvent(e);
    }

    public int getProgress() {
        return (int)(this.deg - 2.0f);
    }

    public void setProgress(int x) {
        this.deg = x + 2;
        this.invalidate();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String txt) {
        this.label = txt;
        this.invalidate();
    }

    public int getBackCircleColor() {
        return this.backCircleColor;
    }

    public void setBackCircleColor(int backCircleColor) {
        this.backCircleColor = backCircleColor;
        this.invalidate();
    }

    public int getMainCircleColor() {
        return this.mainCircleColor;
    }

    public void setMainCircleColor(int mainCircleColor) {
        this.mainCircleColor = mainCircleColor;
        this.invalidate();
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public void setIndicatorColor(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        this.invalidate();
    }

    public int getProgressPrimaryColor() {
        return this.progressPrimaryColor;
    }

    public void setProgressPrimaryColor(int progressPrimaryColor) {
        this.progressPrimaryColor = progressPrimaryColor;
        this.invalidate();
    }

    public int getProgressSecondaryColor() {
        return this.progressSecondaryColor;
    }

    public void setProgressSecondaryColor(int progressSecondaryColor) {
        this.progressSecondaryColor = progressSecondaryColor;
        this.invalidate();
    }

    public int getLabelSize() {
        return this.labelSize;
    }

    public void setLabelSize(int labelSize) {
        this.labelSize = labelSize;
        this.invalidate();
    }

    public int getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(int labelColor) {
        this.labelColor = labelColor;
        this.invalidate();
    }

    public float getIndicatorWidth() {
        return this.indicatorWidth;
    }

    public void setIndicatorWidth(float indicatorWidth) {
        this.indicatorWidth = indicatorWidth;
        this.invalidate();
    }

    public boolean isContinuous() {
        return this.isContinuous;
    }

    public void setIsContinuous(boolean isContinuous) {
        this.isContinuous = isContinuous;
        this.invalidate();
    }

    public float getProgressPrimaryCircleSize() {
        return this.progressPrimaryCircleSize;
    }

    public void setProgressPrimaryCircleSize(float progressPrimaryCircleSize) {
        this.progressPrimaryCircleSize = progressPrimaryCircleSize;
        this.invalidate();
    }

    public float getProgressSecondaryCircleSize() {
        return this.progressSecondaryCircleSize;
    }

    public void setProgressSecondaryCircleSize(float progressSecondaryCircleSize) {
        this.progressSecondaryCircleSize = progressSecondaryCircleSize;
        this.invalidate();
    }

    public float getProgressPrimaryStrokeWidth() {
        return this.progressPrimaryStrokeWidth;
    }

    public void setProgressPrimaryStrokeWidth(float progressPrimaryStrokeWidth) {
        this.progressPrimaryStrokeWidth = progressPrimaryStrokeWidth;
        this.invalidate();
    }

    public float getProgressSecondaryStrokeWidth() {
        return this.progressSecondaryStrokeWidth;
    }

    public void setProgressSecondaryStrokeWidth(float progressSecondaryStrokeWidth) {
        this.progressSecondaryStrokeWidth = progressSecondaryStrokeWidth;
        this.invalidate();
    }

    public int getSweepAngle() {
        return this.sweepAngle;
    }

    public void setSweepAngle(int sweepAngle) {
        this.sweepAngle = sweepAngle;
        this.invalidate();
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
        this.invalidate();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
        this.invalidate();
    }

    public float getMainCircleRadius() {
        return this.mainCircleRadius;
    }

    public void setMainCircleRadius(float mainCircleRadius) {
        this.mainCircleRadius = mainCircleRadius;
        this.invalidate();
    }

    public float getBackCircleRadius() {
        return this.backCircleRadius;
    }

    public void setBackCircleRadius(float backCircleRadius) {
        this.backCircleRadius = backCircleRadius;
        this.invalidate();
    }

    public float getProgressRadius() {
        return this.progressRadius;
    }

    public void setProgressRadius(float progressRadius) {
        this.progressRadius = progressRadius;
        this.invalidate();
    }

    public static interface onProgressChangedListener {
        public void onProgressChanged(int var1);
    }
}

