package com.sdk.wisetracker.base.tracker.common.log;

import android.text.TextUtils;
import android.util.Log;

import com.google.gson.GsonBuilder;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * SDK Log 검증 유틸 클래스
 */
public class WiseValidation {

    public static boolean mIsDebug = false;
    private static final String DOT_VALIDATION_TAG = "DOT_VALIDATION";

    public static void setIsDebug(boolean isDebug) {
        mIsDebug = isDebug;
    }

    public static void dotSdkValidation(String json) {

        try {

            if (!mIsDebug) {
                return;
            }

            JSONArray jsonArray = new JSONArray(json);
            if (jsonArray.length() < 1) {
                return;
            }

            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (jsonObject == null) {
                    return;
                }
                dotSessionValidation(jsonObject);
                dotEventValidation(jsonObject);
            }

        } catch (Exception e) {
            Log.e(DOT_VALIDATION_TAG, "sdk validation error", e);
        }

    }

    // DOT 세션 데이터 검증
    private static void dotSessionValidation(JSONObject jsonObject) {

        try {

            if (!jsonObject.has("SESSION") || jsonObject.getJSONObject("SESSION") == null) {
                return;
            }

            JSONObject sessionObject = jsonObject.getJSONObject("SESSION");

            String visitNew = (String) sessionObject.get("isVisitNew");
            int count = (Integer) sessionObject.get("ltvt");
            if (count > 1 || TextUtils.isEmpty(visitNew) || !visitNew.equalsIgnoreCase("Y")) {
                return;
            }
            String visitTag = "[first app open : true], ";

            String matSource = null;
            if (sessionObject.has("its")) {
                matSource = (String) sessionObject.get("its");
            }
            String matCampaign = null;
            if (sessionObject.has("itc")) {
                matCampaign = (String) sessionObject.get("itc");
            }

            String validationLog;
            String attributionTag;
            if (TextUtils.isEmpty(matSource) && TextUtils.isEmpty(matCampaign)) {
                attributionTag = "[install : organic]";
                validationLog = "Install Type: organic install";
            } else {
                attributionTag = "[matSource : " + matSource + "]," + "[matCampaign : " + matCampaign + "]";
                validationLog = "Install Type: Non-organic install";
            }

            WiseLog.d("SESSION: " + visitTag + attributionTag);
            Log.d(DOT_VALIDATION_TAG, validationLog);
            if (!TextUtils.isEmpty(matSource) && !TextUtils.isEmpty(matCampaign)) {
                Log.d(DOT_VALIDATION_TAG, "Campaign : " + matCampaign);
                Log.d(DOT_VALIDATION_TAG, "Media : " + matSource);
            }

        } catch (Exception e) {
            Log.e(DOT_VALIDATION_TAG, "session validation error", e);
        }

    }

    // DOT 이벤트 데이터 검증
    private static void dotEventValidation(JSONObject jsonObject) {
        try {
            if (jsonObject.has("PAGES")) {
                JSONObject pagesObject = jsonObject.getJSONObject("PAGES");
                String jsonString = pagesObject.toString();
                Log.d(DOT_VALIDATION_TAG, "PAGES: " + jsonString);
                //Log.d(DOT_VALIDATION_TAG, getPrettyJson(jsonString));
            } else if (jsonObject.has("GOAL")) {
                JSONObject goalObject = jsonObject.getJSONObject("GOAL");
                String jsonString = goalObject.toString();
                Log.d(DOT_VALIDATION_TAG, "GOAL: " + jsonString);
                //Log.d(DOT_VALIDATION_TAG, getPrettyJson(jsonString));
            } else if (jsonObject.has("CLICK")) {
                JSONObject clickObject = jsonObject.getJSONObject("CLICK");
                String jsonString = clickObject.toString();
                Log.d(DOT_VALIDATION_TAG, "CLICK: " + jsonString);
                //Log.d(DOT_VALIDATION_TAG, getPrettyJson(jsonString));
            } else if (jsonObject.has("REVENUE")) {
                JSONObject revenueObject = jsonObject.getJSONObject("REVENUE");
                String jsonString = revenueObject.toString();
                Log.d(DOT_VALIDATION_TAG, "REVENUE: " + jsonString);
                //Log.d(DOT_VALIDATION_TAG, getPrettyJson(jsonString));
            }
        } catch (Exception e) {
            Log.e(DOT_VALIDATION_TAG, "event validation error", e);
        }
    }

    private static String getPrettyJson(String json) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(json);
    }

    private static final String DOX_VALIDATION_TAG = "DOX_VALIDATION";

    public static void doxSdkValidation(String json) {
        try {
            if (!mIsDebug) {
                return;
            }
            if (TextUtils.isEmpty(json)) {
                return;
            }
            JSONArray jsonArray = new JSONArray(json);
            if (jsonArray.length() < 1) {
                return;
            }
            for (int i = 0; i < jsonArray.length(); i++) {
                if (jsonArray.getJSONObject(i) == null) {
                    continue;
                }
                doxEventValidation(jsonArray.getJSONObject(i));
            }
        } catch (Exception e) {
            Log.e(DOX_VALIDATION_TAG, "dox sdk validation error", e);
        }
    }

    // DOX 이벤트 데이터 검증
    private static void doxEventValidation(JSONObject jsonObject) {

        try {

            if (jsonObject.has("groupproperties")) {

                JSONObject groupProperties = jsonObject.getJSONObject("groupproperties");
                if (groupProperties == null) {
                    return;
                }
                int sequence = jsonObject.getInt("sequence");
                int eventId = jsonObject.getInt("eventId");
                Log.d(DOX_VALIDATION_TAG, "sequence : " + sequence + ", eventId : " + eventId);
                Log.d(DOX_VALIDATION_TAG, "groupproperties : " + groupProperties.toString());

            } else if (jsonObject.has("userproperties")) {

                JSONObject userProperties = jsonObject.getJSONObject("userproperties");
                if (userProperties == null) {
                    return;
                }
                int sequence = jsonObject.getInt("sequence");
                int eventId = jsonObject.getInt("eventId");
                Log.d(DOX_VALIDATION_TAG, "sequence : " + sequence + ", eventId : " + eventId);
                Log.d(DOX_VALIDATION_TAG, "userproperties : " + userProperties.toString());

            } else if (jsonObject.has("events")) {

                JSONObject events = jsonObject.getJSONObject("events");
                if (events == null) {
                    return;
                }
                int sequence = jsonObject.getInt("sequence");
                int eventId = jsonObject.getInt("eventId");
                Log.d(DOX_VALIDATION_TAG, "sequence : " + sequence + ", eventId : " + eventId);
                Log.d(DOX_VALIDATION_TAG, "events : " + events.toString());

            } else if (jsonObject.has("conversion")) {

                JSONObject conversion = jsonObject.getJSONObject("conversion");
                if (conversion == null) {
                    return;
                }
                int sequence = jsonObject.getInt("sequence");
                int eventId = jsonObject.getInt("eventId");
                Log.d(DOX_VALIDATION_TAG, "sequence : " + sequence + ", eventId : " + eventId);
                Log.d(DOX_VALIDATION_TAG, "conversion : " + conversion.toString());

            } else if (jsonObject.has("revenue")) {

                JSONObject revenue = jsonObject.getJSONObject("revenue");
                if (revenue == null) {
                    return;
                }
                int sequence = jsonObject.getInt("sequence");
                int eventId = jsonObject.getInt("eventId");
                Log.d(DOX_VALIDATION_TAG, "sequence : " + sequence + ", eventId : " + eventId);
                Log.d(DOX_VALIDATION_TAG, "revenue : " + revenue.toString());

            }

        } catch (Exception e) {
            Log.e(DOX_VALIDATION_TAG, "dox event validation error", e);
        }

    }

}