package com.sdk.wisetracker.base.tracker.util;

import android.text.TextUtils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;

import java.util.Iterator;
import java.util.Map;

/**
 * json 생성 util
 * 현재 미사용
 */
public class JsonUtil {

    private final String TAG = "JsonUtil";
    private static JsonUtil instance = null;

    public static JsonUtil getInstance() {
        if (instance == null) {
            instance = new JsonUtil();
        }
        return instance;
    }

    public JsonObject getObjectToJsonString(String type, String previousData, Object data) {

        try {

            String objectJsonString = new Gson().toJson(data);
            JsonElement currentElement = new JsonParser().parse(objectJsonString);
            if (!currentElement.isJsonObject()) {
                return null;
            }

            JsonObject newJsonObject = new JsonObject();
            JsonObject jsonObject = currentElement.getAsJsonObject();
            if (jsonObject != null) {
                setJsonObject(type, jsonObject, newJsonObject);
            }

            return newJsonObject;

        } catch (Exception e) {
            WiseLog.e(e);
        }

        return null;

    }

    private void setJsonObject(String type, JsonObject jsonObject, JsonObject newJsonObject) {
        Iterator iterator = jsonObject.entrySet().iterator();
        String result = jsonIterator(new JsonObject(), iterator);
        JsonElement element = new JsonParser().parse(result);
        newJsonObject.add(type, element);
    }

    private String jsonIterator(JsonObject newJsonObject, Iterator iterator) {

        try {

            while (iterator.hasNext()) {

                Map.Entry<String, JsonElement> map = (Map.Entry<String, JsonElement>) iterator.next();
                JsonElement jsonElement = map.getValue();
                if (jsonElement.isJsonObject()) {
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    jsonIterator(newJsonObject, jsonObject.entrySet().iterator());
                } else {
                    newJsonObject.add(map.getKey(), map.getValue());
                }

            }

            return newJsonObject.toString();

        } catch (Exception e) {
            WiseLog.e(e);
        }

        return null;

    }

    public JsonArray getPreviousData(String previousData) {

        try {

            if (TextUtils.isEmpty(previousData)) {
                return null;
            }

            JsonElement previousDataElement = new JsonParser().parse(previousData);
            if (previousDataElement.isJsonArray()) {
                return previousDataElement.getAsJsonArray();
            }

        } catch (Exception e) {
            WiseLog.e(e);
        }

        return null;

    }


}


/*

public JsonObject getJsonObject(String type) {

        try {

            JsonObject makeJsonObject = new JsonObject();
            String json = new Gson().toJson(this);
            JsonElement rawElement = new JsonParser().parse(json);
            if (rawElement.isJsonObject()) {
                JsonObject rawJsonObject = rawElement.getAsJsonObject();
                iterator(makeJsonObject, rawJsonObject.entrySet().iterator());
            }

            JsonObject resultJsonObject = new JsonObject();
            if (TextUtils.isEmpty(type)) {
                resultJsonObject = makeJsonObject;
            } else {
                resultJsonObject.add(type, makeJsonObject);
            }
            return resultJsonObject;

        } catch (Exception e) {
            WiseLog.e(this.getClass().getSimpleName(), "get json element error !!", e);
        }

        return null;

    }

    private void iterator(JsonObject jsonObject, Iterator<Map.Entry<String, JsonElement>> iterator) {

        try {

            while (iterator.hasNext()) {
                Map.Entry<String, JsonElement> map = iterator.next();
                JsonElement jsonElement = map.getValue();
                if (jsonElement.isJsonObject()) {
                    boolean hasKey = false;
                    if (getExceptionKey() != null && getExceptionKey().length > 0) {
                        for (String key : getExceptionKey()) {
                            if (map.getKey().equals(key)) {
                                hasKey = true;
                                jsonObject.add(map.getKey(), map.getValue());
                                break;
                            }
                        }
                    }
                    if (!hasKey) {
                        iterator(jsonObject, jsonElement.getAsJsonObject().entrySet().iterator());
                    }
                } else {
                    jsonObject.add(map.getKey(), map.getValue());
                }
            }

        } catch (Exception e) {
            WiseLog.e(this.getClass().getSimpleName(), "get json iterator error !!", e);
        }

    }

 */

    /*
    public String getResultJsonString(String previousData, List<Result> currentDataList) {

        try {

            JsonArray combineJsonArray = new JsonArray();

            if (!TextUtils.isEmpty(previousData)) {
                JsonElement previousDataElement = new JsonParser().parse(previousData);
                if (previousDataElement.isJsonArray()) {
                    JsonArray previousJsonArray = previousDataElement.getAsJsonArray();
                    for (int i = 0; i < previousJsonArray.size(); i++) {
                        JsonObject jsonObject = (JsonObject) previousJsonArray.get(i);
                        combineJsonArray.add(jsonObject);
                    }
                }
            }

            String currentData = new Gson().toJson(currentDataList);
            JsonElement currentElement = new JsonParser().parse(currentData);
            JsonArray currentArray = currentElement.getAsJsonArray();

            JsonObject newJsonObject = new JsonObject();

            for (int i = 0; i < currentArray.size(); i++) {

                JsonObject jsonObject = (JsonObject) currentArray.get(i);

                JsonObject session = jsonObject.getAsJsonObject(SESSION);
                if (session != null) {
                    setJsonObject(SESSION, session, newJsonObject);
                }

                JsonObject click = jsonObject.getAsJsonObject(CLICK);
                if (click != null) {
                    setJsonObject(CLICK, click, newJsonObject);
                }

                JsonObject pages = jsonObject.getAsJsonObject(PAGES);
                if (pages != null) {
                    setJsonObject(PAGES, pages, newJsonObject);
                }

                JsonObject goal = jsonObject.getAsJsonObject(GOAL);
                if (goal != null) {
                    setJsonObject(GOAL, goal, newJsonObject);
                }

                JsonObject revenue = jsonObject.getAsJsonObject(REVENUE);
                if (revenue != null) {
                    setJsonObject(REVENUE, revenue, newJsonObject);
                }

                combineJsonArray.add(newJsonObject);

            }

            String result = combineJsonArray.toString();
            return result;

        } catch (Exception e) {
            LogManager.getInstance().e("get json formatter error !!" + e.toString());
        }

        return null;

    }

    public String convertObjectToString(Object object) {

        newJsonObject = new JsonObject();

        String json = new Gson().toJson(object);
        JsonElement element = new JsonParser().parse(json);
        JsonObject rawJsonObject = element.getAsJsonObject();
        Iterator iterator = rawJsonObject.entrySet().iterator();
        String result = jsonIterator(iterator);
        // Log.d("json format result : " + result);
        return result;

    }
    */

    /*

    public String convert(Result result) {

        try {

            JsonObject newJsonObject = new JsonObject();

            String json = new Gson().toJson(result);
            JsonElement element = new JsonParser().parse(json);
            JsonObject originalJsonObject = element.getAsJsonObject();

            JsonObject session = originalJsonObject.getAsJsonObject(SESSION);
            Iterator sessionIterator = session.entrySet().iterator();
            String sessionJsonString = jsonIterator(new JsonObject(), sessionIterator);
            newJsonObject.addProperty(SESSION, sessionJsonString);

            if (originalJsonObject.getAsJsonArray(CLICK) != null) {
                JsonArray jsonArray = getJsonArray(originalJsonObject.getAsJsonArray(CLICK));
                newJsonObject.add(CLICK, jsonArray);
            }

            if (originalJsonObject.getAsJsonArray(PAGES) != null) {
                JsonArray jsonArray = getJsonArray(originalJsonObject.getAsJsonArray(PAGES));
                newJsonObject.add(PAGES, jsonArray);
            }

            if (originalJsonObject.getAsJsonArray(REVENUE) != null) {
                JsonArray jsonArray = getJsonArray(originalJsonObject.getAsJsonArray(REVENUE));
                newJsonObject.add(REVENUE, jsonArray);
            }

            if (originalJsonObject.getAsJsonArray(GOAL) != null) {
                JsonArray jsonArray = getJsonArray(originalJsonObject.getAsJsonArray(GOAL));
                newJsonObject.add(GOAL, jsonArray);
            }

            return newJsonObject.toString();

        } catch (Exception e) {
            Log.e("get error", e);
        }

        return null;

    }

    public JsonArray getJsonArray(JsonArray jsonArray) {

        JsonArray newJsonArray = new JsonArray();

        for (int i = 0; i < jsonArray.size(); i++) {
            JsonElement subElement = jsonArray.get(i);
            JsonObject subJsonObject = subElement.getAsJsonObject();
            Iterator iterator = subJsonObject.entrySet().iterator();
            String resultData = jsonIterator(new JsonObject(), iterator);
            newJsonArray.add(resultData);
        }

        return newJsonArray;

    }

     */
