/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.init;

import android.annotation.SuppressLint;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BasicData;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.concurrent.Callable;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;

public class InitNtpTime {
    private static InitNtpTime instance = null;

    public static InitNtpTime getInstance() {
        if (instance == null) {
            instance = new InitNtpTime();
        }
        return instance;
    }

    @SuppressLint(value={"CheckResult"})
    Observable<Long> getNtpTimeObservable() {
        return Observable.fromCallable((Callable)new Callable<Long>(){

            @Override
            public Long call() {
                try {
                    NTPUDPClient ntpudpClient = new NTPUDPClient();
                    ntpudpClient.setDefaultTimeout(3000);
                    ntpudpClient.open();
                    InetAddress inetAddress = InetAddress.getByName("pool.ntp.org222");
                    TimeInfo timeInfo = ntpudpClient.getTime(inetAddress);
                    ntpudpClient.close();
                    long ntpTime = timeInfo.getMessage().getTransmitTimeStamp().getTime();
                    WiseLog.d("ntpTime get from network  " + ntpTime);
                    long deviceTime = System.currentTimeMillis();
                    long absoluteDiff = Math.abs(ntpTime - deviceTime);
                    return absoluteDiff;
                }
                catch (SocketException e) {
                    WiseLog.d("ntpTime get socket exception !! " + e.getMessage());
                    return 0L;
                }
                catch (Exception e) {
                    WiseLog.d("ntpTime get server time error !! " + e.getMessage());
                    return 0L;
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    void setNtpTime(Long diff) {
        if (diff == null) {
            return;
        }
        if (diff > 1000L) {
            BasicData basicData = BasicDataManager.getInstance().getBasicData();
            basicData.setTimeDiff(diff);
            BasicDataManager.getInstance().saveBasicData(basicData);
        }
    }
}

