/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class WisetrackerDatabase {
    private static final String DATABASE_NAME = "WisetrackerDatabase";
    private static SharedPreferences sharedPreferences = null;

    public static void init(Context context) {
        try {
            sharedPreferences = context.getSharedPreferences(DATABASE_NAME, 0);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    public static void setDatabase(String key, Object value) {
        try {
            if (sharedPreferences == null) {
                return;
            }
            if (value instanceof Long) {
                sharedPreferences.edit().putLong(key, ((Long)value).longValue()).apply();
            } else if (value instanceof Integer) {
                sharedPreferences.edit().putInt(key, ((Integer)value).intValue()).apply();
            } else if (value instanceof String) {
                if (TextUtils.isEmpty((CharSequence)((String)value))) {
                    sharedPreferences.edit().putString(key, (String)value).apply();
                } else {
                    String encodingValue = URLEncoder.encode((String)value, "UTF-8");
                    sharedPreferences.edit().putString(key, encodingValue).apply();
                }
            } else if (value instanceof Map) {
                Map tempMap = new HashMap();
                tempMap = (Map)value;
                JSONObject jsonObject = new JSONObject(tempMap);
                String jsonString = jsonObject.toString();
                sharedPreferences.edit().putString("attributedInfo", jsonString).apply();
            }
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    public static String getStringValue(String key) {
        try {
            if (sharedPreferences == null) {
                return null;
            }
            String data = sharedPreferences.getString(key, null);
            if (!TextUtils.isEmpty((CharSequence)data)) {
                data = URLDecoder.decode(data, "UTF-8");
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            WiseLog.e(e);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
        return null;
    }

    public static int getIntValue(String key) {
        try {
            if (sharedPreferences == null) {
                return 0;
            }
            int data = sharedPreferences.getInt(key, 0);
            return data;
        }
        catch (Exception e) {
            WiseLog.e(e);
            return 0;
        }
    }

    public static long getLongValue(String key) {
        try {
            if (sharedPreferences == null) {
                return 0L;
            }
            long data = sharedPreferences.getLong(key, 0L);
            return data;
        }
        catch (Exception e) {
            WiseLog.e(e);
            return 0L;
        }
    }
}

