package com.sdk.wisetracker.base.tracker.data.init;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;

import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.FingerPrintDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.InstallReferrerDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.OneStoreInstallReferrerDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Token;

import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;

import java.net.InetAddress;
import java.net.SocketException;
import java.util.List;
import java.util.concurrent.Callable;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function3;
import io.reactivex.schedulers.Schedulers;

/**
 * 인스톨 레퍼러 설정
 */
public class InitInstallReferrer {

    private static InitInstallReferrer instance = null;

    public static InitInstallReferrer getInstance() {
        if (instance == null) {
            instance = new InitInstallReferrer();
        }
        return instance;
    }

    /**
     *
     * @param context
     * @return 고객사에서 인스톨 레퍼러 직접 수신 여부 meta-data 설정에 따라 return, 기본값은 false
     */
    private boolean isLoadReferrerAPI(Context context) {

        try {

            // 1. check meta-data disableDotReceiver config
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = appInfo.metaData;
            if (bundle != null && bundle.containsKey("disableDotReceiver")) {
                boolean isDisable = bundle.getBoolean("disableDotReceiver");
                WiseLog.d("sdk disable dot receiver");
                WiseLog.d("sdk disable value : " + isDisable);
                if (isDisable) {
                    return false;
                }
            }

        } catch (PackageManager.NameNotFoundException e) {
            WiseLog.e(e);
        } catch (Exception e) {
            WiseLog.e(e);
        }

        return true;

    }

    /**
     * 인스톨 레퍼러 수신 및 설정 후 핑거프린트 호출
     * 앱 설치 후 최초 실행시에만 1회 수행
     * @param context
     * @param callBack
     */
    public void loadInstallReferrer(Context context, ReferrerInitCallBack callBack) {

        WiseLog.d("load referrer");

        if (!isLoadReferrerAPI(context)) {
            callBack.onCallback(true);
            return;
        }



        /****
        final InstallReferrerClient installReferrerClient = InstallReferrerClient.newBuilder(context).build();
        installReferrerClient.startConnection(new InstallReferrerStateListener() {

            @Override
            public void onInstallReferrerSetupFinished(int responseCode) {
                try {
                    switch (responseCode) {
                        case InstallReferrerClient.InstallReferrerResponse.OK:
                            WiseLog.d("install referrer response is ok");
                            InstallReferrerDataManager.getInstance().checkInstallReferrer(installReferrerClient.getInstallReferrer());
                            FingerPrintDataManager.getInstance().loadFingerPrintByInstall(callBack);
                            break;
                        default:
                            WiseLog.d("install referrer response is not ok");
                            FingerPrintDataManager.getInstance().loadFingerPrintByInstall(callBack);
                    }
                } catch (RemoteException re) {
                    WiseLog.d("get install begin time error !!" + re.getMessage());
                } catch (Exception e) {
                    WiseLog.d("exception occurs !!" + e.getMessage());
                }
            }

            @Override
            public void onInstallReferrerServiceDisconnected() {
                WiseLog.d("onInstallReferrerServiceDisconnected !!");
            }

        });
        ***/

        Observable<com.android.installreferrer.api.ReferrerDetails> googleReferrer = this.getGoogleInstallReferrer();
        Observable<OneStoreInstallReferrerDataManager.ReferrerDetails> oneStoreReferrer = this.getOneStoreInstallReferrer();
        Observable.zip(googleReferrer, oneStoreReferrer, new BiFunction<ReferrerDetails, OneStoreInstallReferrerDataManager.ReferrerDetails, Object>() {
            @Override
            public Object apply(ReferrerDetails google, OneStoreInstallReferrerDataManager.ReferrerDetails oneStore) {
                WiseLog.d("Observable.zip start! ");
                if( google != null && oneStore == null ){
                    return google;
                }else if( google == null && oneStore != null ){
                    return oneStore;
                }else{
                    if( google != null && oneStore != null ){
                        long googleClkTime = google.getInstallBeginTimestampSeconds();
                        long oneStoreClkTime = oneStore.getInstallBeginTimestampSeconds();
                        if( googleClkTime > 0 && oneStoreClkTime == 0 ){
                            return google;
                        }else if( googleClkTime == 0 && oneStoreClkTime > 0 ){
                            return oneStore;
                        }else{
                            if( googleClkTime > oneStoreClkTime ) {
                                return google;
                            }else if( googleClkTime < oneStoreClkTime ){
                                return oneStore;
                            }else{
                                if( google.getInstallReferrer() != null && !(google.getInstallReferrer()).equals("")){
                                    return google;
                                }else{
                                    return "NoData";
                                }
                            }
                        }
                    }else{
                        return "NoData";
                    }
                }
            }
        })
        .subscribeOn(Schedulers.io())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new Consumer<Object>() {
            @Override
            public void accept(Object _result) {
                WiseLog.d("Observable.zip result : "+ _result );
                // Google , OneStore, FingerPrint
                if( _result instanceof ReferrerDetails ){
                    InstallReferrerDataManager.getInstance().checkInstallReferrer((ReferrerDetails)_result);
                }else if( _result instanceof OneStoreInstallReferrerDataManager.ReferrerDetails ){
                    InstallReferrerDataManager.getInstance().checkInstallReferrer((OneStoreInstallReferrerDataManager.ReferrerDetails)_result);
                }
                FingerPrintDataManager.getInstance().loadFingerPrintByInstall(callBack);
            }
        }, new Consumer<Throwable>() {
            @Override
            public void accept(Throwable throwable) {
                WiseLog.e(throwable);
            }
        });

    }

    // OneStore Referrer Observable
    public boolean oneStoreObserveFlag = false;
    Observable<OneStoreInstallReferrerDataManager.ReferrerDetails> getOneStoreInstallReferrer() {
        oneStoreObserveFlag = true;
        return Observable.fromCallable(new Callable<OneStoreInstallReferrerDataManager.ReferrerDetails>() {
            @Override
            public OneStoreInstallReferrerDataManager.ReferrerDetails call() {
                Intent serviceIntent = new Intent(OneStoreInstallReferrerDataManager.SERVICE_ACTION_NAME);
                boolean connectionResult = false;
                try{
                    for (String servicePackageName : OneStoreInstallReferrerDataManager.SERVICE_PACKAGE_NAMES) {
                        serviceIntent.setComponent(new ComponentName(servicePackageName, OneStoreInstallReferrerDataManager.SERVICE_NAME));
                        List<ResolveInfo> intentServices = InitializeManager.applicationContext.getPackageManager().queryIntentServices(serviceIntent, 0);
                        if (intentServices != null && !intentServices.isEmpty()) {
                            if (OneStoreInstallReferrerDataManager.getInstance().isOneStoreCompatible(servicePackageName)) {
                                connectionResult = InitializeManager.applicationContext.bindService(serviceIntent, OneStoreInstallReferrerDataManager.getInstance().getmServiceConnection(), Context.BIND_AUTO_CREATE);
                            }
                            break;
                        }
                    }
                    if (connectionResult) {
                        WiseLog.d(" OneStore Service connected!");
                        while(oneStoreObserveFlag){}
                        WiseLog.d("OneStore receive data : " + OneStoreInstallReferrerDataManager.getInstance().mReferrerDetails.getInstallReferrer() );
                        return OneStoreInstallReferrerDataManager.getInstance().mReferrerDetails;
                    } else {
                        WiseLog.d(" OneStore Service not connected! Return Empty ");
                        return OneStoreInstallReferrerDataManager.getInstance().getEmptyReferrer();
                    }
                }catch(Exception e){
                    return OneStoreInstallReferrerDataManager.getInstance().getEmptyReferrer();
                }
            }
        });
    }

    // Google Referrer Observable
    public boolean googleStoreObserveFlag = false;
    @SuppressLint("CheckResult")
    Observable<com.android.installreferrer.api.ReferrerDetails> getGoogleInstallReferrer() {
        googleStoreObserveFlag = true;
        return Observable.fromCallable(new Callable<ReferrerDetails>() {
            @Override
            public ReferrerDetails call() {
                final ReferrerDetails[] _receviedReferrer = {null};
                try {
                    final InstallReferrerClient installReferrerClient = InstallReferrerClient.newBuilder(InitializeManager.applicationContext).build();
                    installReferrerClient.startConnection(new InstallReferrerStateListener() {
                        @Override
                        public void onInstallReferrerSetupFinished(int responseCode) {
                            try {
                                switch (responseCode) {
                                    case InstallReferrerClient.InstallReferrerResponse.OK:
                                        WiseLog.d("install referrer response is ok "+ installReferrerClient.getInstallReferrer().getInstallReferrer() );
                                        _receviedReferrer[0] = installReferrerClient.getInstallReferrer();
                                        break;
                                    default:
                                        Bundle emptyReferrer = new Bundle();
                                        emptyReferrer.putString("install_referrer","");
                                        emptyReferrer.putLong("referrer_click_timestamp_seconds",0L);
                                        emptyReferrer.putLong("install_begin_timestamp_seconds",0L);
                                        _receviedReferrer[0] = new ReferrerDetails(emptyReferrer);
                                        WiseLog.d("install referrer response is not ok");
                                }
                            } catch (RemoteException re) {
                                WiseLog.d("get install begin time error !!" + re.getMessage());
                            } catch (Exception e) {
                                WiseLog.d("exception occurs !!" + e.getMessage());
                            } finally{
                                if ( _receviedReferrer[0] == null ){
                                    Bundle emptyReferrer = new Bundle();
                                    emptyReferrer.putString("install_referrer","");
                                    emptyReferrer.putLong("referrer_click_timestamp_seconds",0L);
                                    emptyReferrer.putLong("install_begin_timestamp_seconds",0L);
                                    _receviedReferrer[0] = new ReferrerDetails(emptyReferrer);
                                }
                                googleStoreObserveFlag = false;
                            }
                        }
                        @Override
                        public void onInstallReferrerServiceDisconnected() {
                            WiseLog.d("onInstallReferrerServiceDisconnected !!");
                            googleStoreObserveFlag = false;
                        }

                    });
                } catch (Exception e) {
                    WiseLog.d("get server time error !! " + e.getMessage());
                    Bundle emptyReferrer = new Bundle();
                    emptyReferrer.putString("install_referrer","");
                    emptyReferrer.putLong("referrer_click_timestamp_seconds",0L);
                    emptyReferrer.putLong("install_begin_timestamp_seconds",0L);
                    _receviedReferrer[0] = new ReferrerDetails(emptyReferrer);
                }
                while(googleStoreObserveFlag){}
                if( _receviedReferrer[0] != null ){
                    WiseLog.d("Google receive data : " + _receviedReferrer[0].getInstallReferrer() );
                }
                return _receviedReferrer[0];
            }
        })
        .subscribeOn(Schedulers.io())
        .observeOn(AndroidSchedulers.mainThread());
    }


}
