/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.util;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import java.util.Iterator;
import java.util.Map;

public class JsonUtil {
    private final String TAG = "JsonUtil";
    private static JsonUtil instance = null;

    public static JsonUtil getInstance() {
        if (instance == null) {
            instance = new JsonUtil();
        }
        return instance;
    }

    public JsonObject getObjectToJsonString(String type, String previousData, Object data) {
        try {
            String objectJsonString = new Gson().toJson(data);
            JsonElement currentElement = new JsonParser().parse(objectJsonString);
            if (!currentElement.isJsonObject()) {
                return null;
            }
            JsonObject newJsonObject = new JsonObject();
            JsonObject jsonObject = currentElement.getAsJsonObject();
            if (jsonObject != null) {
                this.setJsonObject(type, jsonObject, newJsonObject);
            }
            return newJsonObject;
        }
        catch (Exception e) {
            WiseLog.e(e);
            return null;
        }
    }

    private void setJsonObject(String type, JsonObject jsonObject, JsonObject newJsonObject) {
        Iterator iterator = jsonObject.entrySet().iterator();
        String result = this.jsonIterator(new JsonObject(), iterator);
        JsonElement element = new JsonParser().parse(result);
        newJsonObject.add(type, element);
    }

    private String jsonIterator(JsonObject newJsonObject, Iterator iterator) {
        try {
            while (iterator.hasNext()) {
                Map.Entry map = (Map.Entry)iterator.next();
                JsonElement jsonElement = (JsonElement)map.getValue();
                if (jsonElement.isJsonObject()) {
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    this.jsonIterator(newJsonObject, jsonObject.entrySet().iterator());
                    continue;
                }
                newJsonObject.add((String)map.getKey(), (JsonElement)map.getValue());
            }
            return newJsonObject.toString();
        }
        catch (Exception e) {
            WiseLog.e(e);
            return null;
        }
    }

    public JsonArray getPreviousData(String previousData) {
        try {
            if (TextUtils.isEmpty((CharSequence)previousData)) {
                return null;
            }
            JsonElement previousDataElement = new JsonParser().parse(previousData);
            if (previousDataElement.isJsonArray()) {
                return previousDataElement.getAsJsonArray();
            }
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
        return null;
    }
}

