/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.background;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.sdk.wisetracker.base.tracker.common.WisetrackerDatabase;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BasicData;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Session;
import com.sdk.wisetracker.base.tracker.network.SessionApi;
import com.sdk.wisetracker.base.tracker.network.SessionRetrofit;
import com.sdk.wisetracker.base.tracker.network.request.RequestRetention;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

public class RetentionWorker
extends Worker {
    private final String RETENTION_COUNT = "RETENTION_COUNT";
    private final String LAST_RETENTION_TIME = "LAST_RETENTION_TIME";

    public RetentionWorker(Context context, WorkerParameters workerParams) {
        super(context, workerParams);
    }

    public ListenableWorker.Result doWork() {
        try {
            WiseLog.d("retention worker execute");
            WisetrackerDatabase.init(this.getApplicationContext());
            int retentionCount = WisetrackerDatabase.getIntValue("RETENTION_COUNT");
            WiseLog.d("retention count = " + retentionCount);
            if (retentionCount > 0) {
                long lastRetentionTime = WisetrackerDatabase.getLongValue("LAST_RETENTION_TIME");
                if (lastRetentionTime == 0L) {
                    WiseLog.d("retention diff time = " + lastRetentionTime);
                } else {
                    WiseLog.d("retention diff time = " + (System.currentTimeMillis() - lastRetentionTime) / 1000L * 60L + "minute");
                }
                WisetrackerDatabase.setDatabase("LAST_RETENTION_TIME", System.currentTimeMillis());
                this.sendRetention();
            }
            WisetrackerDatabase.setDatabase("RETENTION_COUNT", ++retentionCount);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
        return ListenableWorker.Result.success();
    }

    @SuppressLint(value={"CheckResult"})
    private void sendRetention() {
        WiseLog.d("send retention");
        SessionApi api = SessionRetrofit.getInstance().getBaseApi(SessionApi.class, HeaderType.DOT);
        api.sendRetention(this.getRequestRetention()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<JsonObject>(){

            public void accept(JsonObject jsonObject) {
                BasicData basicData = BasicDataManager.getInstance().getBasicData();
                long currentTime = System.currentTimeMillis() + basicData.getTimeDiff();
                basicData.setLastRetentionTime(currentTime);
                BasicDataManager.getInstance().saveBasicData(basicData);
                WiseLog.d("send retention success");
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                WiseLog.e(throwable);
            }
        }, new Action(){

            public void run() {
                WiseLog.d("send retention complete");
            }
        });
    }

    private RequestRetention getRequestRetention() {
        try {
            BasicData basicData = BasicDataManager.getInstance().getBasicData();
            Session session = SessionDataManager.getInstance().getSession();
            RequestRetention requestRetention = new RequestRetention();
            requestRetention.setServiceNumber(String.valueOf(session.getServiceNumber()));
            requestRetention.setInstallChannel(session.getAdInstallSource());
            requestRetention.setInstallCampaign(session.getAdInstallCampaign());
            requestRetention.setInstallTye(session.getAdInstallType());
            requestRetention.setInstallKeyword(session.getAdInstallKeyword());
            requestRetention.setInstallTime(basicData.getFirstAppOpenTime());
            requestRetention.setLastRetentionTime(basicData.getLastRetentionTime());
            requestRetention.setAdId(session.getAdId());
            WiseLog.d("request retention : " + new Gson().toJson((Object)requestRetention));
            return requestRetention;
        }
        catch (Exception e) {
            WiseLog.e(e);
            return new RequestRetention();
        }
    }
}

