/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.common.log;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.JsonObject;
import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Session;
import com.sdk.wisetracker.base.tracker.network.SessionApi;
import com.sdk.wisetracker.base.tracker.network.SessionRetrofit;
import com.sdk.wisetracker.base.tracker.network.request.RequestError;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;

public class WiseLog {
    private static final String TAG = "[WiseLog]";
    private static List<String> logList = new ArrayList<String>();
    private static boolean isDebug = true;

    public static void d(String message) {
        message = WiseLog.getMessage(3, message);
        WiseLog.debugPrint(message);
    }

    private static void debugPrint(String message) {
        if (isDebug) {
            Log.d((String)TAG, (String)message);
        } else {
            logList.add(message);
        }
    }

    public static void e(Throwable throwable) {
        String message = WiseLog.getMessage(6, null);
        String errorMessage = WiseLog.getErrorMessage(throwable);
        WiseLog.errorPrint(message, errorMessage);
    }

    public static void e(String message, Throwable throwable) {
        message = WiseLog.getMessage(6, message);
        String errorMessage = WiseLog.getErrorMessage(throwable);
        WiseLog.errorPrint(message, errorMessage);
    }

    private static void errorPrint(String message, String errorMessage) {
        if (isDebug) {
            Log.e((String)TAG, (String)message);
            Log.e((String)TAG, (String)errorMessage);
        } else {
            StringBuilder allLog = new StringBuilder();
            allLog.append("---- ERROR PRINT----\n");
            for (String log : logList) {
                allLog.append(log).append("\n");
            }
            allLog.append(message + "\n");
            allLog.append(errorMessage + "\n");
            Log.e((String)TAG, (String)allLog.toString());
            WiseLog.sendLogData(allLog.toString());
        }
    }

    private static String getCallInfo(int index) {
        StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
        StackTraceElement element = stackTraceElements[index];
        String className = element.getClassName();
        String[] classArray = className.split("\\.");
        className = classArray[classArray.length - 1];
        String methodName = element.getMethodName();
        int lineNumber = element.getLineNumber();
        return className + "#" + methodName + "(" + lineNumber + ")";
    }

    private static String getMessage(int priority, String message) {
        String status = priority == 3 ? "#DEBUG" : "#ERROR";
        String info = WiseLog.getCallInfo(3);
        if (TextUtils.isEmpty((CharSequence)message)) {
            return info + status + "_CALL";
        }
        return info + status + "_MESSAGE#" + message;
    }

    private static String getErrorMessage(Throwable throwable) {
        String errorMessage = "#EXCEPTION_MESSAGE#" + throwable.getMessage();
        return errorMessage;
    }

    private static RequestError getRequestError(String logString) {
        try {
            Session session = SessionDataManager.getInstance().getSession();
            RequestError requestError = new RequestError();
            requestError.setServiceNumber(String.valueOf(session.getServiceNumber()));
            requestError.setErrLog(logString);
            requestError.setDeepLink(session.getDeepLinkReferrer());
            requestError.setInstallReferrer(session.getInstallReferrer());
            return requestError;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"#CREATE_REQUEST_ERROR_FAIL");
            return new RequestError();
        }
    }

    @SuppressLint(value={"CheckResult"})
    private static void sendLogData(String logDataString) {
        SessionApi api = SessionRetrofit.getInstance().getBaseApi(SessionApi.class, HeaderType.DOT);
        api.sendLog(WiseLog.getRequestError(logDataString)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<JsonObject>(){

            public void accept(JsonObject jsonObject) {
                Log.d((String)WiseLog.TAG, (String)"#SEND_LOG_DATA_SUCCESS");
                if (jsonObject != null) {
                    Log.d((String)WiseLog.TAG, (String)("#JSON_STRING ->" + jsonObject.toString()));
                }
                logList.clear();
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                Log.d((String)WiseLog.TAG, (String)"#SEND_LOG_DATA_FAIL");
                Log.d((String)WiseLog.TAG, (String)("#" + throwable.getMessage()));
            }
        });
    }
}

