/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.manager;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.android.installreferrer.api.ReferrerDetails;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BaseDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.OneStoreInstallReferrerDataManager;
import com.sdk.wisetracker.base.tracker.util.ValueOf;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class InstallReferrerDataManager
extends BaseDataManager {
    private static InstallReferrerDataManager instance = null;

    public static InstallReferrerDataManager getInstance() {
        if (instance == null) {
            instance = new InstallReferrerDataManager();
        }
        return instance;
    }

    @Override
    public void setData() {
    }

    @Override
    public void afterTransaction() {
        this.session.setIsReferrerUpdate("N");
        if (this.session.getAdIdChange().equals("Y")) {
            this.session.setAdIdChange("N");
            this.resetReferrer();
        }
        super.afterTransaction();
    }

    public void setFacebookReferrer(Bundle bundle) {
        try {
            String clickTime;
            WiseLog.d("Facebook referrer: " + bundle.toString());
            if (bundle == null) {
                return;
            }
            String referrer = null;
            if ((bundle.containsKey("target_url") || bundle.containsKey("com.facebook.platform.APPLINK_NATIVE_URL")) && TextUtils.isEmpty((CharSequence)(referrer = bundle.getString("target_url")))) {
                referrer = bundle.getString("com.facebook.platform.APPLINK_NATIVE_URL");
            }
            if (bundle.containsKey("click_time") && TextUtils.isEmpty((CharSequence)(clickTime = bundle.getString("click_time")))) {
                referrer = referrer + "&_wtclkTime=" + clickTime;
            }
            if (TextUtils.isEmpty((CharSequence)referrer)) {
                WiseLog.d("facebook referrer data is null or empty");
                return;
            }
            this.session.setIsReferrerUpdate("Y");
            this.session.setInstallReferrer(referrer);
            this.session.setBeginTime(0L);
            this.session.setClickTime(0L);
            this.setInstallReferrer(referrer);
        }
        catch (Exception e) {
            WiseLog.e("set facebook referrer get exception !!", e);
        }
    }

    public void checkInstallReferrer(ReferrerDetails referrerDetails) {
        if (referrerDetails == null) {
            WiseLog.d(" Google response is null");
            return;
        }
        this.checkInstallReferrer(referrerDetails.getInstallBeginTimestampSeconds(), referrerDetails.getReferrerClickTimestampSeconds(), referrerDetails.getInstallReferrer(), "playstore");
    }

    public void checkInstallReferrer(OneStoreInstallReferrerDataManager.ReferrerDetails referrerDetails) {
        if (referrerDetails == null) {
            WiseLog.d("OneStore response is null");
            return;
        }
        this.checkInstallReferrer(referrerDetails.getInstallBeginTimestampSeconds(), referrerDetails.getReferrerClickTimestampSeconds(), referrerDetails.getInstallReferrer(), "onestore");
    }

    private void checkInstallReferrer(long _beginTime, long _clickTime, String _referrer, String storeName) {
        try {
            long beginTime = _beginTime;
            long clickTime = _clickTime;
            WiseLog.d("ir begin time : " + beginTime);
            WiseLog.d("ir click time : " + clickTime);
            WiseLog.d("ir install referrer : " + _referrer);
            String referrer = _referrer;
            if (TextUtils.isEmpty((CharSequence)referrer)) {
                WiseLog.d("install referrer data is null or empty");
                return;
            }
            boolean isWtc = referrer.contains("_wtc");
            boolean isWts = referrer.contains("_wts");
            if (!isWtc && !isWts) {
                WiseLog.d("invalid install referrer data");
                return;
            }
            String adInstallSource = this.session.getAdInstallSource();
            WiseLog.d("adInstallSource in checkInstallReferrer: " + adInstallSource);
            if (adInstallSource != null && !adInstallSource.equals("")) {
                return;
            }
            WiseLog.d("------------------------ Install Referrer set ( start ) ----------------------------");
            WiseLog.d(storeName);
            WiseLog.d(referrer);
            WiseLog.d(String.valueOf(beginTime * 1000L));
            WiseLog.d(String.valueOf(clickTime * 1000L));
            this.session.setAppStoreName(storeName);
            this.session.setIsReferrerUpdate("Y");
            this.session.setInstallReferrer(referrer);
            this.session.setBeginTime(beginTime * 1000L);
            this.session.setClickTime(clickTime * 1000L);
            this.setInstallReferrer(referrer);
            WiseLog.d("------------------------ Install Referrer set ( end ) ----------------------------");
        }
        catch (Exception e) {
            WiseLog.e("check install referrer error !!", e);
        }
    }

    private void setInstallReferrer(String referrer) {
        Uri uri = Uri.parse((String)referrer);
        Set queryParameters = uri.getQueryParameterNames();
        if (queryParameters == null || queryParameters.isEmpty()) {
            this.setInstallReferrerByMapParameter(referrer);
        } else {
            this.setInstallReferrerByQueryParameter(uri, queryParameters);
        }
        this.referrerValidation();
    }

    private void setInstallReferrerByQueryParameter(Uri uri, Set<String> queryParameters) {
        WiseLog.d("setInstallReferrerByQueryParameter called " + queryParameters.toString());
        Iterator<String> iterator = queryParameters.iterator();
        while (iterator.hasNext()) {
            String name;
            switch (name = iterator.next()) {
                case "_wts": {
                    this.session.setAdInstallSource(uri.getQueryParameter(name));
                    break;
                }
                case "_wtm": {
                    this.session.setAdInstallType(uri.getQueryParameter(name));
                    break;
                }
                case "_wtc": {
                    this.session.setAdInstallCampaign(uri.getQueryParameter(name));
                    break;
                }
                case "_wtw": {
                    this.session.setAdInstallKeyword(uri.getQueryParameter(name));
                    break;
                }
                case "_wtclkTime": {
                    this.session.setAdInstallClickTime(ValueOf.longValue(uri.getQueryParameter(name)));
                    break;
                }
                case "_wtaffid": {
                    this.session.setInstallDepth1(uri.getQueryParameter(name));
                    break;
                }
                case "_wtbffid": {
                    this.session.setInstallDepth2(uri.getQueryParameter(name));
                    break;
                }
                case "_wtckp": {
                    this.session.setAdInstallExpireTime(ValueOf.intValue(uri.getQueryParameter(name)));
                    break;
                }
                case "_wtcid": {
                    this.session.setClickId(uri.getQueryParameter(name));
                    break;
                }
                case "_wgcmpid": {
                    this.session.setGoogleCampaignId(uri.getQueryParameter(name));
                }
            }
        }
    }

    private void setInstallReferrerByMapParameter(String referrer) {
        String[] map = referrer.split("&");
        List<String> parameters = Arrays.asList(map);
        WiseLog.d("setInstallReferrerByMapParameter called " + parameters);
        for (String query : parameters) {
            if (TextUtils.isEmpty((CharSequence)query)) {
                WiseLog.d("empty   ");
                continue;
            }
            String[] data = query.split("=");
            if (data.length < 2) {
                WiseLog.d("length error  ");
                continue;
            }
            String key = data[0];
            String value = data[1];
            WiseLog.d("find Key " + key + "/" + value);
            switch (key) {
                case "_wts": {
                    this.session.setAdInstallSource(value);
                    break;
                }
                case "_wtm": {
                    this.session.setAdInstallType(value);
                    break;
                }
                case "_wtc": {
                    this.session.setAdInstallCampaign(value);
                    break;
                }
                case "_wtw": {
                    this.session.setAdInstallKeyword(value);
                    break;
                }
                case "_wtclkTime": {
                    this.session.setAdInstallClickTime(ValueOf.longValue(value));
                    break;
                }
                case "_wtaffid": {
                    this.session.setInstallDepth1(value);
                    break;
                }
                case "_wtbffid": {
                    this.session.setInstallDepth2(value);
                    break;
                }
                case "_wtckp": {
                    this.session.setAdInstallExpireTime(ValueOf.intValue(value));
                    break;
                }
                case "_wtcid": {
                    this.session.setClickId(value);
                    break;
                }
                case "_wgcmpid": {
                    this.session.setGoogleCampaignId(value);
                }
            }
        }
    }

    private void referrerValidation() {
        String adInstallSource = this.session.getAdInstallSource();
        String adInstallCampaign = this.session.getAdInstallCampaign();
        if (TextUtils.isEmpty((CharSequence)adInstallSource) || TextUtils.isEmpty((CharSequence)adInstallCampaign)) {
            WiseLog.d("referrer doesn't have primary key");
            this.resetReferrer();
            return;
        }
        if (this.session.getAdInstallClickTime() == 0L) {
            this.session.setAdInstallClickTime(System.currentTimeMillis());
        }
        if (this.session.getAdInstallClickTime() + (long)(60000 * this.session.getAdInstallExpireTime()) < System.currentTimeMillis()) {
            WiseLog.d("invalid install referrer");
            this.resetReferrer();
            return;
        }
    }

    private void resetReferrer() {
        this.session.setAdInstallSource(null);
        this.session.setAdInstallType(null);
        this.session.setAdInstallCampaign(null);
        this.session.setAdInstallKeyword(null);
        this.session.setAdInstallClickTime(0L);
        this.session.setInstallDepth1(null);
        this.session.setInstallDepth2(null);
        this.session.setAdInstallExpireTime(0);
        this.session.setIsReferrerUpdate(null);
        this.session.setInstallReferrer(null);
        this.session.setBeginTime(0L);
        this.session.setClickTime(0L);
        this.session.setGoogleCampaignId(null);
    }
}

