package com.sdk.wisetracker.base.tracker.network.interceptor;

import android.os.Build;
import android.text.TextUtils;

import com.sdk.wisetracker.base.BuildConfig;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BasicData;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;
import com.sdk.wisetracker.base.tracker.util.AES256Util;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * API 호출시 헤더 정보 추가 Interceptor
 */
public class RetrofitHeaderInterceptor implements Interceptor {

    private String tag;
    private HeaderType headerType;

    public RetrofitHeaderInterceptor(String tag, HeaderType headerType) {
        this.tag = tag;
        this.headerType = headerType;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {

        try {

            Request.Builder builder = chain.request().newBuilder();
            String versionName = BuildConfig.VERSION_NAME;
            String deviceModel = Build.MODEL;
            int osVersion = Build.VERSION.SDK_INT;
            builder.addHeader("User-Agent", "DOT/" + versionName + "/" + deviceModel + "/" + osVersion + "");

            if (headerType == null || headerType.equals(HeaderType.BASE)) {
                return chain.proceed(chain.request().newBuilder().build());
            }

            if (headerType.equals(HeaderType.TOKEN)) {
                builder.addHeader("authType", AES256Util.getInstance().aesEncode("dotAmWisetracker", "TOKEN"));
            } else if (headerType.equals(HeaderType.FRP)) {
                builder.addHeader("authType", AES256Util.getInstance().aesEncode("dotAmWisetracker", "FRP"));
            } else if (headerType.equals(HeaderType.DOT)) {
                BasicData basicData = BasicDataManager.getInstance().getBasicData();
                String accessToken = basicData.getToken();
                if (!TextUtils.isEmpty(accessToken)) {
                    builder.addHeader("authType", AES256Util.getInstance().aesEncode("dotAmWisetracker", "DOT"));
                    builder.addHeader("authToken", accessToken);
                }
            }

            return chain.proceed(builder.build());

        } catch (Exception e) {
            WiseLog.e(e);
        }

        return chain.proceed(chain.request().newBuilder().build());

    }

}
