package com.sdk.wisetracker.base.tracker.network;

import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Session;
import com.sdk.wisetracker.base.tracker.network.interceptor.RetrofitHeaderInterceptor;
import com.sdk.wisetracker.base.tracker.network.interceptor.RetrofitLogInterceptor;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;

import okhttp3.Interceptor;

/**
 * 세션 관련 API 호출 담당 클래스
 */
public class SessionRetrofit extends BaseRetrofit<SessionApi> {

    private static SessionRetrofit instance = null;

    public static SessionRetrofit getInstance() {
        if (instance == null) {
            instance = new SessionRetrofit();
        }
        return instance;
    }

    @Override
    public String getTag() {
        return "SessionRetrofit";
    }

    @Override
    public String getUrl() {
        Session session = SessionDataManager.getInstance().getSession();
        return session.getDomain();
    }

    @Override
    public Interceptor getHeaderInterceptor(HeaderType type) {
        return new RetrofitHeaderInterceptor(getTag(), type);
    }

    @Override
    public Interceptor getLogInterceptor() {
        return new RetrofitLogInterceptor(getTag());
    }

}
