package com.sdk.wisetracker.base.tracker.data.manager;

import android.text.TextUtils;

import com.google.gson.Gson;
import com.sdk.wisetracker.base.tracker.common.WisetrackerDatabase;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.util.TimeUtil;

/**
 * BasicData 모델 관리 매니져 class
 */
public class BasicDataManager {

    private static BasicDataManager instance = null;
    private BasicData basicData;

    public static BasicDataManager getInstance() {
        if (instance == null) {
            instance = new BasicDataManager();
        }
        return instance;
    }

    // 저장된 BasicData 데이터 로드 및 생성
    public BasicDataManager() {
        String jsonString = WisetrackerDatabase.getStringValue(BasicData.class.getSimpleName());
        if (TextUtils.isEmpty(jsonString)) {
            basicData = new BasicData();
        } else {
            basicData = new Gson().fromJson(jsonString, BasicData.class);
            if (basicData == null) {
                basicData = new BasicData();
            }
        }
        WiseLog.d("basic data : " + new Gson().toJson(basicData));
    }

    public void saveBasicData(BasicData basicData) {
        String jsonString = new Gson().toJson(basicData);
        WisetrackerDatabase.setDatabase(BasicData.class.getSimpleName(), jsonString);
    }

    public BasicData getBasicData() {
        return basicData;
    }

    // 뉴세션 체크
    public boolean isNewSession() {
        long eventTime = getBasicData().getLastAppEventTime();
        WiseLog.d("event time : " + eventTime);
        long currentTime = (System.currentTimeMillis() - eventTime);
        WiseLog.d("current time : " + currentTime);
        boolean isNew = eventTime == 0 || (int) (currentTime / TimeUtil.MINUTE_MILLIS) > 30;
        WiseLog.d("check new session : " + isNew);
        return isNew;
    }

}
