package com.sdk.wisetracker.base.tracker.data.init;

import android.annotation.SuppressLint;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BasicData;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;

import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;

import java.net.InetAddress;
import java.net.SocketException;
import java.util.concurrent.Callable;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

public class InitNtpTime {

    private static InitNtpTime instance = null;

    public static InitNtpTime getInstance() {
        if (instance == null) {
            instance = new InitNtpTime();
        }
        return instance;
    }

    /**
     * NTP-TIME 정보 호출
     * @return observable
     */
    @SuppressLint("CheckResult")
    Observable<Long> getNtpTimeObservable() {

        return Observable.fromCallable(new Callable<Long>() {

            @Override
            public Long call() {

                try {

                    NTPUDPClient ntpudpClient = new NTPUDPClient();
                    ntpudpClient.setDefaultTimeout(3000);
                    ntpudpClient.open();
                    InetAddress inetAddress = InetAddress.getByName("pool.ntp.org");
                    TimeInfo timeInfo = ntpudpClient.getTime(inetAddress);
                    ntpudpClient.close();
                    long ntpTime = timeInfo.getMessage().getTransmitTimeStamp().getTime();
                    // TODO: 2018. 7. 23. 배포시 수정 테스트 전용
                    ntpTime = System.currentTimeMillis();
                    long deviceTime = System.currentTimeMillis();
                    long absoluteDiff = Math.abs(ntpTime - deviceTime);
                    return absoluteDiff;

                } catch (SocketException e) {
                    WiseLog.d("get socket exception !! " + e.getMessage());
                    return System.currentTimeMillis();
                } catch (Exception e) {
                    WiseLog.d("get server time error !! " + e.getMessage());
                    return System.currentTimeMillis();
                }

            }

        })
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());

    }

    /**
     * NTP-TIME 저장
     * @param diff
     */
    void setNtpTime(Long diff) {
        if (diff == null) {
            return;
        }
        if (diff > 1000) {
            BasicData basicData = BasicDataManager.getInstance().getBasicData();
            basicData.setTimeDiff(diff);
            BasicDataManager.getInstance().saveBasicData(basicData);
        }
    }

}
