package com.sdk.wisetracker.base.open.controller;

import android.content.Intent;
import android.os.Bundle;

import com.android.installreferrer.api.ReferrerDetails;
import com.sdk.wisetracker.base.open.model.InternalCampaign;
import com.sdk.wisetracker.base.open.model.User;
import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;

/**
 * DOT API 통해 전달 되는 Session 처리 controller
 */
public class BaseController {

    public static void setDeepLink(Intent intent) {
        SessionDataManager.getInstance().setDeepLink(intent);
    }

    public static void setDeepLink(String url) {
        SessionDataManager.getInstance().setDeepLink(url);
    }

    public static void setInstallReferrer(ReferrerDetails referrerDetails) {
        SessionDataManager.getInstance().setInstallReferrer(referrerDetails);
    }

    public static void setPushReceiver(Intent intent) {
        SessionDataManager.getInstance().setPushReceiver(intent);
    }

    public static void setPushClick(Intent intent) {
        SessionDataManager.getInstance().setPushClick(intent);
    }

    public static void setPushToken(String pushToken) {
        SessionDataManager.getInstance().setPushToken(pushToken);
    }

    public static void setFacebookReferrer(Bundle bundle) {
        SessionDataManager.getInstance().setFacebookReferrer(bundle);
    }

    public static void setUser(User user) {
        SessionDataManager.getInstance().setUser(user);
    }

    public static void setInternalCampaign(InternalCampaign campaign){
        SessionDataManager.getInstance().setInternalCampaign(campaign);
    }

    public static void setUserLogout() {
        SessionDataManager.getInstance().setUserLogout();
    }

}
