/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.network;

import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Session;
import com.sdk.wisetracker.base.tracker.network.BaseRetrofit;
import com.sdk.wisetracker.base.tracker.network.SessionApi;
import com.sdk.wisetracker.base.tracker.network.interceptor.RetrofitHeaderInterceptor;
import com.sdk.wisetracker.base.tracker.network.interceptor.RetrofitLogInterceptor;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;
import okhttp3.Interceptor;

public class SessionRetrofit
extends BaseRetrofit<SessionApi> {
    private static SessionRetrofit instance = null;

    public static SessionRetrofit getInstance() {
        if (instance == null) {
            instance = new SessionRetrofit();
        }
        return instance;
    }

    @Override
    public String getTag() {
        return "SessionRetrofit";
    }

    @Override
    public String getUrl() {
        Session session = SessionDataManager.getInstance().getSession();
        return session.getDomain();
    }

    @Override
    public Interceptor getHeaderInterceptor(HeaderType type) {
        return new RetrofitHeaderInterceptor(this.getTag(), type);
    }

    @Override
    public Interceptor getLogInterceptor() {
        return new RetrofitLogInterceptor(this.getTag());
    }
}

