/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.manager;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import com.android.installreferrer.api.ReferrerDetails;
import com.google.gson.Gson;
import com.sdk.wisetracker.base.open.model.User;
import com.sdk.wisetracker.base.tracker.common.WisetrackerDatabase;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BaseDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.DeepLinkDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.InstallReferrerDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.PushDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.UserDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.VisitDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Session;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SessionDataManager {
    private Session session;
    private List<BaseDataManager> dataManagerList;
    private static SessionDataManager instance = null;
    public static PublishSubject<Boolean> deepLinkSubject = PublishSubject.create();

    public static SessionDataManager getInstance() {
        if (instance == null) {
            instance = new SessionDataManager();
        }
        return instance;
    }

    public SessionDataManager() {
        String jsonString = WisetrackerDatabase.getStringValue(Session.class.getSimpleName());
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            this.session = new Session();
        } else {
            this.session = (Session)new Gson().fromJson(jsonString, Session.class);
            if (this.session == null) {
                this.session = new Session();
            }
            this.resetSession();
        }
        WiseLog.d("session data : " + new Gson().toJson((Object)this.session));
    }

    private void resetSession() {
        this.session.setPiTrace(null);
        this.session.setSearchFail(null);
    }

    public void saveSession(Session session) {
        String jsonString = new Gson().toJson((Object)session);
        WisetrackerDatabase.setDatabase(Session.class.getSimpleName(), jsonString);
    }

    public Session getSession() {
        return this.session;
    }

    public List<BaseDataManager> getDataManagerList() {
        if (this.dataManagerList == null) {
            this.dataManagerList = new ArrayList<BaseDataManager>();
            this.dataManagerList.add(DeepLinkDataManager.getInstance());
            this.dataManagerList.add(InstallReferrerDataManager.getInstance());
            this.dataManagerList.add(PushDataManager.getInstance());
            this.dataManagerList.add(VisitDataManager.getInstance());
        }
        return this.dataManagerList;
    }

    public void setSdkVersion(Pair<String, String> pair) {
        Map<String, String> sdkVersionMap = this.session.getSdkVersion();
        if (sdkVersionMap == null) {
            return;
        }
        sdkVersionMap.put((String)pair.first, (String)pair.second);
        this.session.setSdkVersion(sdkVersionMap);
    }

    public void setOpenPlatform(String openPlatform) {
        this.session.setOpenPlatform(openPlatform);
    }

    public Session getUpdateSessionData() {
        for (BaseDataManager manager : this.getDataManagerList()) {
            manager.setData();
        }
        return this.getSession();
    }

    public void updateSessionAfterTransaction() {
        for (BaseDataManager manager : this.getDataManagerList()) {
            manager.afterTransaction();
        }
    }

    public void setPushClick(Intent intent) {
        PushDataManager.getInstance().setPushClick(intent);
    }

    public void setPushToken(String pushToken) {
        PushDataManager.getInstance().setPushToken(pushToken);
    }

    public void setPushReceiver(Intent intent) {
        PushDataManager.getInstance().setPushReceiverId(intent);
    }

    public void setDeepLink(Intent intent) {
        DeepLinkDataManager.getInstance().openDeepLink(intent);
    }

    public void setDeepLink(String url) {
        DeepLinkDataManager.getInstance().openDeepLink(url);
    }

    public void setInstallReferrer(ReferrerDetails referrerDetails) {
        InstallReferrerDataManager.getInstance().checkInstallReferrer(referrerDetails);
    }

    public void setFacebookReferrer(Bundle bundle) {
        InstallReferrerDataManager.getInstance().setFacebookReferrer(bundle);
    }

    public void setUser(User user) {
        UserDataManager.getInstance().setUser(user);
    }

    public void setUserLogout() {
        UserDataManager.getInstance().setUserLogout();
    }

    public void setUserId(String userId) {
        UserDataManager.getInstance().setUserId(userId);
    }

    public void onPageEvent(String searchFail, String piTraceString) {
        VisitDataManager.getInstance().onPageEvent(searchFail, piTraceString);
    }

    public void onPurchaseEvent(long lifePurchaseAmount, String orderNumber) {
        VisitDataManager.getInstance().onPurchaseEvent(lifePurchaseAmount, orderNumber);
    }
}

