/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.init;

import android.annotation.SuppressLint;
import android.content.Context;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.sdk.wisetracker.base.tracker.common.WisetrackerDatabase;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.init.InitAdvertisingId;
import com.sdk.wisetracker.base.tracker.data.init.InitAppKey;
import com.sdk.wisetracker.base.tracker.data.init.InitAppOpen;
import com.sdk.wisetracker.base.tracker.data.init.InitEnvironment;
import com.sdk.wisetracker.base.tracker.data.init.InitInstallReferrer;
import com.sdk.wisetracker.base.tracker.data.init.InitNtpTime;
import com.sdk.wisetracker.base.tracker.data.init.InitToken;
import com.sdk.wisetracker.base.tracker.data.init.ReferrerInitCallBack;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Token;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function3;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;

public class InitializeManager {
    public static boolean initComplete = false;
    public static Context applicationContext = null;
    public static PublishSubject<Boolean> initSubject = PublishSubject.create();
    private static ReferrerInitCallBack referrerInitCallBack = new ReferrerInitCallBack(){

        @Override
        public void onCallback(boolean isComplete) {
            initComplete = true;
            initSubject.onNext((Object)true);
        }
    };

    public static void init(Context context) {
        try {
            InitializeManager.baseInit(context);
            InitializeManager.asyncInit(context);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    private static void baseInit(Context context) {
        applicationContext = context;
        WiseLog.d("init call");
        WiseLog.d("init context info -> " + context);
        WisetrackerDatabase.init(context);
        InitAppOpen.getInstance().checkAppOpen();
        InitAppKey.getInstance().setAppKey(context);
        InitEnvironment.getInstance().setEnvironment(context);
    }

    @SuppressLint(value={"CheckResult"})
    private static void asyncInit(final Context context) {
        Observable<AdvertisingIdClient.Info> advertisingObservable = InitAdvertisingId.getInstance().getAdvertisingObservable(context);
        Observable<Long> ntpTimeObservable = InitNtpTime.getInstance().getNtpTimeObservable();
        Observable<Token> tokenObservable = InitToken.getInstance().getAccessTokenObservable();
        Observable.zip(advertisingObservable, ntpTimeObservable, tokenObservable, (Function3)new Function3<AdvertisingIdClient.Info, Long, Token, Boolean>(){

            public Boolean apply(AdvertisingIdClient.Info info, Long diff, Token token) {
                InitAdvertisingId.getInstance().setAdvertisingId(info);
                InitNtpTime.getInstance().setNtpTime(diff);
                return InitToken.getInstance().isValidToken(token);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean isValid) {
                if (!isValid.booleanValue()) {
                    WiseLog.d("token is invalid");
                    return;
                }
                boolean isFirstAppOpen = BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y");
                WiseLog.d("!!!! isFirstAppOpen : " + isFirstAppOpen);
                WiseLog.d("!!!! BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen() : " + BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen());
                if (!isFirstAppOpen) {
                    initComplete = true;
                    initSubject.onNext((Object)true);
                    return;
                }
                InitInstallReferrer.getInstance().loadInstallReferrer(context, referrerInitCallBack);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                WiseLog.e(throwable);
            }
        });
    }
}

