package com.sdk.wisetracker.base.tracker.data.manager;

import android.text.TextUtils;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.util.TimeUtil;

import java.util.UUID;

/**
 * 세션의 방문 데이터 관련 정보 업데이트 class
 */
public class VisitDataManager extends BaseDataManager {

    private static VisitDataManager instance = null;

    public static VisitDataManager getInstance() {
        if (instance == null) {
            instance = new VisitDataManager();
        }
        return instance;
    }

    @Override
    public void setData() {
        setPureSession();
        setVisitSession();
        setPurchaseSession();
    }

    @Override
    public void afterTransaction() {
        session.setFirstPurchase("N");
        session.setSpendingTimeToPurchase(0);
        session.setSpendingVisitToPurchase(0);
        super.afterTransaction();
    }

    // 일.주(일요일~토요일).월 방문자 체크
    private void setPureSession() {

        try {

            // 발급 받은 세션 시간 기준 Daily, Weekly, Monthly User Check
            long sessionTime = basicData.getLastSessionTime();
            if (sessionTime == 0) {

                session.setDailyUnique("Y");
                session.setWeeklyUnique("Y");
                session.setWeeklyUnique2("Y");
                session.setMonthlyUnique("Y");

            } else {

                int day = TimeUtil.getInstance().getDay(sessionTime);
                int weekOfMonth = TimeUtil.getInstance().getWeekOfMonth(sessionTime);
                int month = TimeUtil.getInstance().getMonth(sessionTime);

                long currentTime = System.currentTimeMillis();
                int currentDay = TimeUtil.getInstance().getDay(currentTime);
                int currentWeekOfMonth = TimeUtil.getInstance().getWeekOfMonth(currentTime);
                int currentMonth = TimeUtil.getInstance().getMonth(currentTime);

                session.setDailyUnique((month == currentMonth) && (day == currentDay) ? "N" : "Y");
                if (month == currentMonth && weekOfMonth == currentWeekOfMonth) {
                    session.setWeeklyUnique("N");
                } else {
                    session.setWeeklyUnique("Y");
                }
                session.setMonthlyUnique(month == currentMonth ? "N" : "Y");
                setWeeklyUnique(sessionTime);

            }

        } catch (Exception e) {
            WiseLog.e(e);
        }

    }

    // 주 (월요일~일요일) 방문자 체크
    private void setWeeklyUnique(long time) {

        int dayOfWeek = TimeUtil.getInstance().getDayOfWeek(time);
        int weekOfMonth = TimeUtil.getInstance().getWeekOfMonth(time);

        int currentDayOfWeek = TimeUtil.getInstance().getDayOfWeek(System.currentTimeMillis());
        int currentWeekOfMonth = TimeUtil.getInstance().getWeekOfMonth(System.currentTimeMillis());

        if (weekOfMonth == currentWeekOfMonth) {
            if (dayOfWeek == 1 && currentDayOfWeek > 1) {
                session.setWeeklyUnique2("Y");
            } else {
                session.setWeeklyUnique2("N");
            }
        } else {
            if (currentWeekOfMonth - weekOfMonth == 1) {
                if (currentDayOfWeek > 1) {
                    session.setWeeklyUnique2("Y");
                } else {
                    session.setWeeklyUnique2("N");
                }
            } else if (Math.abs(currentWeekOfMonth - weekOfMonth) > 1) {
                session.setWeeklyUnique2("Y");
            }
        }

    }

    // 방문 설정 체크
    private void setVisitSession() {

        try {

            String sessionId = session.getSessionId();
            int sessionCount = session.getLifeCriteriaVisit();
            int purchaseSessionCount = session.getSpendingVisitToPurchase();
            int visitCount = session.getUserCriteriaVisit();
            long eventTime = basicData.getLastAppEventTime();
            int dailyTerm = TimeUtil.getInstance().dailyTerm(basicData.getFirstAppOpenTime());
            boolean isNew = TimeUtil.getInstance().newSession(eventTime);
            if (isNew) {
                sessionId = UUID.randomUUID().toString();
                sessionCount += 1;
                purchaseSessionCount += 1;
                visitCount = TimeUtil.getInstance().isExpire(eventTime) ? 1 : visitCount + 1;
                basicData.setLastSessionTime(System.currentTimeMillis());
            }
            basicData.setLastAppEventTime(System.currentTimeMillis());

            session.setSessionId(sessionId);
            session.setLifeCriteriaVisit(sessionCount);
            session.setSpendingVisitToPurchase(purchaseSessionCount);
            session.setUserCriteriaVisit(visitCount);
            session.setLifeVisitInterval(dailyTerm);
            session.setVisitNew(isNew ? "Y" : "N");

        } catch (Exception e) {
            WiseLog.e(e);
        }

    }

    // 구매 데이터 체크
    private void setPurchaseSession() {
        try {
            long purchaseTime = basicData.getLastPurchaseTime();
            int purchaseCount = session.getUserCriteriaPurchase();
            if (TimeUtil.getInstance().isExpire(purchaseTime)) {
                purchaseCount = 0;
            }
            session.setUserCriteriaPurchase(purchaseCount);
        } catch (Exception e) {
            WiseLog.e(e);
        }
    }

    // 페이지 이벤트 발생시 PI 설정
    public void onPageEvent(String searchFail, String piTraceString) {
        try {
            session.setSearchFail(searchFail);
            String piTrace = session.getPiTrace();
            if (!TextUtils.isEmpty(piTraceString)) {
                piTrace = TextUtils.isEmpty(piTrace) ? "" : piTrace + "|";
                piTrace = piTrace + piTraceString;
            }
            session.setPiTrace(piTrace);
        } catch (Exception e) {
            WiseLog.e(e);
        }
    }

    // 구매 이벤트 발생시 관련 세션 데이터 설정
    public void onPurchaseEvent(long lifePurchaseAmount, String orderNumber) {

        try {

            long purchaseTime = basicData.getLastPurchaseTime();
            if (purchaseTime == 0) {
                session.setUserCriteriaPurchase(1);
                session.setLifeCriteriaPurchase(1);
                session.setLifePurchaseInterval(0);
                session.setFirstPurchase("Y");
            } else {
                session.setUserCriteriaPurchase(TimeUtil.getInstance().isExpire(purchaseTime) ? 1 : session.getUserCriteriaPurchase() + 1);
                session.setLifeCriteriaPurchase(session.getLifeCriteriaPurchase() + 1);
                session.setLifePurchaseInterval((int) ((basicData.getFirstAppOpenTime() - purchaseTime) / TimeUtil.DAY_MILLIS));
                session.setFirstPurchase("N");
            }

            basicData.setLastPurchaseTime(System.currentTimeMillis());
            session.setSpendingTimeToPurchase((System.currentTimeMillis() - basicData.getLastSessionTime()) / TimeUtil.SECOND_MILLIS);
            session.setSpendingVisitToPurchase(0);
            session.setLastOrderNumber(orderNumber);
            session.setLifePurchaseAmount(session.getLifePurchaseAmount() + lifePurchaseAmount);

        } catch (Exception e) {
            WiseLog.e("on purchase action data set error !!", e);
        }

    }

}


/**
 * //    // 현재 단말기 시간 + 오차시간 (NTP 타임 - DEVICE 타임)
 * //    long ntpTime = SessionDB.getInstance().getPrimitiveLongData(SessionDB.PARAM.INIT.NTP_TIME);
 * //    long deviceTime = SessionDB.getInstance().getPrimitiveLongData(SessionDB.PARAM.INIT.DEVICE_TIME);
 * //    long diff = ntpTime - deviceTime;
 * //    long currentDeviceTime = System.currentTimeMillis();
 * //    // 1초 이상 차이 나면 +
 * //                SessionDB.getInstance().setPrimitiveData(SessionDB.PARAM.INIT.NTP_TIME, Math.abs(diff) > 1000 ? currentDeviceTime + diff : currentDeviceTime);
 * //                SessionDB.getInstance().setPrimitiveData(SessionDB.PARAM.INIT.DEVICE_TIME, currentDeviceTime);
 */