package com.sdk.wisetracker.base.tracker.data.init;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;

import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.FingerPrintDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.InstallReferrerDataManager;

/**
 * 인스톨 레퍼러 설정
 */
public class InitInstallReferrer {

    private static InitInstallReferrer instance = null;

    public static InitInstallReferrer getInstance() {
        if (instance == null) {
            instance = new InitInstallReferrer();
        }
        return instance;
    }

    /**
     *
     * @param context
     * @return 고객사에서 인스톨 레퍼러 직접 수신 여부 meta-data 설정에 따라 return, 기본값은 false
     */
    private boolean isLoadReferrerAPI(Context context) {

        try {

            // 1. check meta-data disableDotReceiver config
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = appInfo.metaData;
            if (bundle != null && bundle.containsKey("disableDotReceiver")) {
                boolean isDisable = bundle.getBoolean("disableDotReceiver");
                WiseLog.d("sdk disable dot receiver");
                WiseLog.d("sdk disable value : " + isDisable);
                if (isDisable) {
                    return false;
                }
            }

        } catch (PackageManager.NameNotFoundException e) {
            WiseLog.e(e);
        } catch (Exception e) {
            WiseLog.e(e);
        }

        return true;

    }

    /**
     * 인스톨 레퍼러 수신 및 설정 후 핑거프린트 호출
     * 앱 설치 후 최초 실행시에만 1회 수행
     * @param context
     * @param callBack
     */
    public void loadInstallReferrer(Context context, ReferrerInitCallBack callBack) {

        WiseLog.d("load referrer");

        if (!isLoadReferrerAPI(context)) {
            callBack.onCallback(true);
            return;
        }

        final InstallReferrerClient installReferrerClient = InstallReferrerClient.newBuilder(context).build();
        installReferrerClient.startConnection(new InstallReferrerStateListener() {

            @Override
            public void onInstallReferrerSetupFinished(int responseCode) {
                try {
                    switch (responseCode) {
                        case InstallReferrerClient.InstallReferrerResponse.OK:
                            WiseLog.d("install referrer response is ok");
                            InstallReferrerDataManager.getInstance().checkInstallReferrer(installReferrerClient.getInstallReferrer());
                            FingerPrintDataManager.getInstance().loadFingerPrintByInstall(callBack);
                            break;
                        default:
                            WiseLog.d("install referrer response is not ok");
                            FingerPrintDataManager.getInstance().loadFingerPrintByInstall(callBack);
                    }
                } catch (RemoteException re) {
                    WiseLog.d("get install begin time error !!" + re.getMessage());
                } catch (Exception e) {
                    WiseLog.d("exception occurs !!" + e.getMessage());
                }
            }

            @Override
            public void onInstallReferrerServiceDisconnected() {
                WiseLog.d("onInstallReferrerServiceDisconnected !!");
            }

        });

    }

}
