package com.sdk.wisetracker.base.tracker.data.init;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.google.gson.Gson;
import com.sdk.wisetracker.base.R;
import com.sdk.wisetracker.base.tracker.common.exception.InitializeAppKey2Exception;
import com.sdk.wisetracker.base.tracker.common.exception.InitializeAppKeyException;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.common.log.WiseValidation;
import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * SDK 초기화시 사용자 'dotAuthorizationKey' 정보 추출 및 저장
 */
public class InitAppKey {

    private final String TAG = "InitAppKey";
    private static InitAppKey instance = null;

    public static InitAppKey getInstance() {
        if (instance == null) {
            instance = new InitAppKey();
        }
        return instance;
    }

    private List<CharSequence> getAppKeyList(Context context) {
        try {
            List<CharSequence> appKeyList = new ArrayList<>(Arrays.asList(context.getResources().getTextArray(R.array.dotAuthorizationKey)));
            if (appKeyList == null || appKeyList.isEmpty()) {
                throw new InitializeAppKeyException();
            }
            return appKeyList;
        } catch (NoClassDefFoundError e) {
            authKeyExceptionHandling(context);
        } catch (InitializeAppKeyException e) {
            Log.d(TAG, "check your app key");
            Log.d(TAG, "check Strings.xml \'useMode\'");
            Log.e(TAG, "init app key  exception", e);
        } catch (Exception e) {
            WiseLog.e(e);
        }
        return null;
    }

    public void setAppKey(Context context) {
        List<CharSequence> appKeyList = getAppKeyList(context);
        if (appKeyList == null || appKeyList.isEmpty()) {
            return;
        }
        String useMode = appKeyList.get(0).toString();
        if (TextUtils.isEmpty(useMode)) {
            return;
        }
        if (useMode.equals("1") || useMode.equals("2")) {
            setDOTAppKey(appKeyList);
        } else if (useMode.equals("3")) {
            setDOXAppKey(appKeyList);
        }
    }

    private void setDOTAppKey(List<CharSequence> appKeyList) {
        if (appKeyList.size() < 8) {
            return;
        }
        Session session = SessionDataManager.getInstance().getSession();
        session.setUseMode(appKeyList.get(0).toString());
        session.setDomain(appKeyList.get(1).toString());
        session.setServiceNumber(Integer.valueOf(appKeyList.get(2).toString()));
        session.setExpireDate(Integer.valueOf(appKeyList.get(3).toString()));
        session.setDebug(Boolean.valueOf(appKeyList.get(4).toString()));
        WiseValidation.setIsDebug(Boolean.valueOf(appKeyList.get(4).toString()));
        session.setInstallRetention(Boolean.valueOf(appKeyList.get(5).toString()));
        session.setFingerPrint(Boolean.valueOf(appKeyList.get(6).toString()));
        session.setAccessToken(appKeyList.get(7).toString());
        if (appKeyList.size() == 9) {
            session.setDomainX(appKeyList.get(8).toString());
        }
        SessionDataManager.getInstance().saveSession(session);
    }

    private void setDOXAppKey(List<CharSequence> appKeyList) {
        Session session = SessionDataManager.getInstance().getSession();
        session.setUseMode(appKeyList.get(0).toString());
        session.setDomain(appKeyList.get(1).toString());
        session.setServiceNumber(Integer.valueOf(appKeyList.get(2).toString()));
        session.setExpireDate(Integer.valueOf(appKeyList.get(3).toString()));
        session.setDebug(Boolean.valueOf(appKeyList.get(4).toString()));
        WiseValidation.setIsDebug(Boolean.valueOf(appKeyList.get(4).toString()));
        session.setInstallRetention(Boolean.valueOf(appKeyList.get(5).toString()));
        session.setFingerPrint(Boolean.valueOf(appKeyList.get(6).toString()));
        session.setAccessToken(appKeyList.get(7).toString());
        session.setDomainX(appKeyList.get(8).toString());
        SessionDataManager.getInstance().saveSession(session);
    }

    // 유니티 리소스 파일 접근 불가로 AndroidManifest.xml 파일에 auth key 선언 예외 처리
    private void authKeyExceptionHandling(Context context) {

        try {

            WiseLog.d("auth key exception handling for unity");

            String useMode = null;
            List<CharSequence> appKeyList = new ArrayList<>();
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = appInfo.metaData;

            if (bundle.containsKey("useMode")) {
                useMode = String.valueOf(bundle.getInt("useMode"));
            }

            if (TextUtils.isEmpty(useMode)) {
                Log.d(TAG, "check your app key");
                Log.d(TAG, "check AndroidManifest.xml \'useMode\'");
                Log.e(TAG, "init app key  exception", new InitializeAppKey2Exception());
                return;
            }

            appKeyList.add(useMode);

            if (bundle.containsKey("domain")) {
                appKeyList.add(bundle.getString("domain"));
            }

            if (bundle.containsKey("serviceNumber")) {
                appKeyList.add(String.valueOf(bundle.getInt("serviceNumber")));
            }
            if (bundle.containsKey("expireDate")) {
                appKeyList.add(String.valueOf(bundle.getInt("expireDate")));
            }
            if (bundle.containsKey("isDebug")) {
                appKeyList.add(String.valueOf(bundle.getBoolean("isDebug")));
            }
            if (bundle.containsKey("isInstallRetention")) {
                appKeyList.add(String.valueOf(bundle.getBoolean("isInstallRetention")));
            }
            if (bundle.containsKey("isFingerPrint")) {
                appKeyList.add(String.valueOf(bundle.getBoolean("isFingerPrint")));
            }
            if (bundle.containsKey("accessToken")) {
                appKeyList.add(bundle.getString("accessToken"));
            }
            if (bundle.containsKey("domain_x")) {
                appKeyList.add(bundle.getString("domain_x"));
            }

            setDOTAppKey(appKeyList);

        } catch (Exception e) {
            WiseLog.e("auth key exceptionHandling error", e);
        }

    }

}