/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.util;

import android.text.TextUtils;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import java.util.Calendar;

public class TimeUtil {
    private static TimeUtil instance = null;
    public static final int SECOND_MILLIS = 1000;
    public static final int MINUTE_MILLIS = 60000;
    public static final int HOUR_MILLIS = 3600000;
    public static final int DAY_MILLIS = 86400000;
    private int EXPIRE_DATE = 14;

    public static TimeUtil getInstance() {
        if (instance == null) {
            instance = new TimeUtil();
        }
        return instance;
    }

    public int dailyTerm(long time) {
        return time == 0L ? 0 : (int)((System.currentTimeMillis() - time) / 86400000L);
    }

    public boolean newSession(long time) {
        return time == 0L || (int)((System.currentTimeMillis() - time) / 60000L) > 30;
    }

    public void setExpireDate(String expireDate) {
        try {
            if (TextUtils.isEmpty((CharSequence)expireDate)) {
                return;
            }
            this.EXPIRE_DATE = Integer.valueOf(expireDate);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    public boolean isExpire(long time) {
        if (time == 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return (currentTime - time) / 86400000L >= (long)this.EXPIRE_DATE;
    }

    public int getDay(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int day = calendar.get(5);
        return day;
    }

    public int getDayOfWeek(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int week = calendar.get(7);
        return week;
    }

    public int getWeekOfMonth(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int weekOfMonth = calendar.get(4);
        return weekOfMonth;
    }

    public int getMonth(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int month = calendar.get(2) + 1;
        return month;
    }
}

