/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.manager;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import java.util.Set;

public class SupportManager {
    private final String TAG = "SupportManager";
    private static SupportManager instance = null;
    private String supportUrl = null;

    public static SupportManager getInstance() {
        if (instance == null) {
            instance = new SupportManager();
        }
        return instance;
    }

    public void setSupportUrl(Intent intent) {
        try {
            WiseLog.d("set support url");
            if (intent == null) {
                return;
            }
            String url = intent.getData().toString();
            WiseLog.d("url : " + url);
            if (TextUtils.isEmpty((CharSequence)url)) {
                return;
            }
            Uri uri = Uri.parse((String)url);
            Set queryParameters = uri.getQueryParameterNames();
            if (queryParameters == null || queryParameters.isEmpty()) {
                WiseLog.d("query param is null or empty");
                return;
            }
            for (String key : queryParameters) {
                if (TextUtils.isEmpty((CharSequence)key)) {
                    WiseLog.d("key is empty");
                    continue;
                }
                WiseLog.d("key : " + key);
                switch (key) {
                    case "apiUrl": {
                        this.supportUrl = uri.getQueryParameter(key);
                    }
                }
            }
            WiseLog.d("support url : " + this.supportUrl);
        }
        catch (Exception e) {
            Log.e((String)"SupportManager", (String)"set support url error !!", (Throwable)e);
        }
    }

    public String getSupportUrl() {
        return this.supportUrl;
    }
}

