package com.sdk.wisetracker.base.tracker.data.init;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Session;

import java.io.IOException;
import java.util.concurrent.Callable;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

/**
 * ADID 추출 Observable
 */
public class InitAdvertisingId {

    private static InitAdvertisingId instance = null;

    public static InitAdvertisingId getInstance() {
        if (instance == null) {
            instance = new InitAdvertisingId();
        }
        return instance;
    }

    @SuppressLint("CheckResult")
    Observable<AdvertisingIdClient.Info> getAdvertisingObservable(Context context) {

        return Observable.fromCallable(new Callable<AdvertisingIdClient.Info>() {

            @Override
            public AdvertisingIdClient.Info call() {

                try {
                    AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo(context);
                    setAdvertisingId(info);
                    return info;
                } catch (GooglePlayServicesNotAvailableException e) {
                    WiseLog.d("google play service not available exception !! " + e.getMessage());
                } catch (GooglePlayServicesRepairableException e) {
                    WiseLog.d("google play service repairable exception !! " + e.getMessage());
                } catch (IOException e) {
                    WiseLog.d("get i.o exception error !! " + e.getMessage());
                } catch (Exception e) {
                    WiseLog.d("get ad info error !! " + e.getMessage());
                }

                AdvertisingIdClient.Info info = new AdvertisingIdClient.Info("AdvertisingIdClient_is_null", true);
                setAdvertisingId(info);
                return info;

            }

        })
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());

    }

    void setAdvertisingId(AdvertisingIdClient.Info info) {
        if (info == null) {
            return;
        }
        Session session = SessionDataManager.getInstance().getSession();
        if (!TextUtils.isEmpty(session.getAdId()) && !session.getAdId().equals(info.getId())) {
            session.setAdIdChange("Y");
        } else {
            session.setAdIdChange("N");
        }
        session.setAdId(info.getId());
        session.setAdFlag(info.isLimitAdTrackingEnabled() ? 1 : 0);
        SessionDataManager.getInstance().saveSession(session);
    }

}
