/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.network.interceptor;

import android.os.Build;
import android.text.TextUtils;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BasicData;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;
import com.sdk.wisetracker.base.tracker.util.AES256Util;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetrofitHeaderInterceptor
implements Interceptor {
    private String tag;
    private HeaderType headerType;

    public RetrofitHeaderInterceptor(String tag, HeaderType headerType) {
        this.tag = tag;
        this.headerType = headerType;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        try {
            BasicData basicData;
            String accessToken;
            Request.Builder builder = chain.request().newBuilder();
            String versionName = "0.0.11";
            String deviceModel = Build.MODEL;
            int osVersion = Build.VERSION.SDK_INT;
            builder.addHeader("User-Agent", "DOT/" + versionName + "/" + deviceModel + "/" + osVersion + "");
            if (this.headerType == null || this.headerType.equals((Object)HeaderType.BASE)) {
                return chain.proceed(chain.request().newBuilder().build());
            }
            if (this.headerType.equals((Object)HeaderType.TOKEN)) {
                builder.addHeader("authType", AES256Util.getInstance().aesEncode("dotAmWisetracker", "TOKEN"));
            } else if (this.headerType.equals((Object)HeaderType.FRP)) {
                builder.addHeader("authType", AES256Util.getInstance().aesEncode("dotAmWisetracker", "FRP"));
            } else if (this.headerType.equals((Object)HeaderType.DOT) && !TextUtils.isEmpty((CharSequence)(accessToken = (basicData = BasicDataManager.getInstance().getBasicData()).getToken()))) {
                builder.addHeader("authType", AES256Util.getInstance().aesEncode("dotAmWisetracker", "DOT"));
                builder.addHeader("authToken", accessToken);
            }
            return chain.proceed(builder.build());
        }
        catch (Exception e) {
            WiseLog.e(e);
            return chain.proceed(chain.request().newBuilder().build());
        }
    }
}

