/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.manager;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.sdk.wisetracker.base.tracker.common.WisetrackerDatabase;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BasicData;

public class BasicDataManager {
    private static BasicDataManager instance = null;
    private BasicData basicData;

    public static BasicDataManager getInstance() {
        if (instance == null) {
            instance = new BasicDataManager();
        }
        return instance;
    }

    public BasicDataManager() {
        String jsonString = WisetrackerDatabase.getStringValue(BasicData.class.getSimpleName());
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            this.basicData = new BasicData();
        } else {
            this.basicData = (BasicData)new Gson().fromJson(jsonString, BasicData.class);
            if (this.basicData == null) {
                this.basicData = new BasicData();
            }
        }
        WiseLog.d("basic data : " + new Gson().toJson((Object)this.basicData));
    }

    public void saveBasicData(BasicData basicData) {
        String jsonString = new Gson().toJson((Object)basicData);
        WisetrackerDatabase.setDatabase(BasicData.class.getSimpleName(), jsonString);
    }

    public BasicData getBasicData() {
        return this.basicData;
    }

    public boolean isNewSession() {
        long eventTime = this.getBasicData().getLastAppEventTime();
        WiseLog.d("event time : " + eventTime);
        long currentTime = System.currentTimeMillis() - eventTime;
        WiseLog.d("current time : " + currentTime);
        boolean isNew = eventTime == 0L || (int)(currentTime / 60000L) > 30;
        WiseLog.d("check new session : " + isNew);
        return isNew;
    }
}

