/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.init;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.init.ReferrerInitCallBack;
import com.sdk.wisetracker.base.tracker.data.manager.FingerPrintDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.InstallReferrerDataManager;

public class InitInstallReferrer {
    private static InitInstallReferrer instance = null;

    public static InitInstallReferrer getInstance() {
        if (instance == null) {
            instance = new InitInstallReferrer();
        }
        return instance;
    }

    private boolean isLoadReferrerAPI(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = appInfo.metaData;
            if (bundle != null && bundle.containsKey("disableDotReceiver")) {
                boolean isDisable = bundle.getBoolean("disableDotReceiver");
                WiseLog.d("sdk disable dot receiver");
                WiseLog.d("sdk disable value : " + isDisable);
                if (isDisable) {
                    return false;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            WiseLog.e(e);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
        return true;
    }

    public void loadInstallReferrer(Context context, final ReferrerInitCallBack callBack) {
        WiseLog.d("load referrer");
        if (!this.isLoadReferrerAPI(context)) {
            callBack.onCallback(true);
            return;
        }
        final InstallReferrerClient installReferrerClient = InstallReferrerClient.newBuilder((Context)context).build();
        installReferrerClient.startConnection(new InstallReferrerStateListener(){

            public void onInstallReferrerSetupFinished(int responseCode) {
                try {
                    switch (responseCode) {
                        case 0: {
                            WiseLog.d("install referrer response is ok");
                            InstallReferrerDataManager.getInstance().checkInstallReferrer(installReferrerClient.getInstallReferrer());
                            FingerPrintDataManager.getInstance().loadFingerPrintByInstall(callBack);
                            break;
                        }
                        default: {
                            WiseLog.d("install referrer response is not ok");
                            FingerPrintDataManager.getInstance().loadFingerPrintByInstall(callBack);
                            break;
                        }
                    }
                }
                catch (RemoteException re) {
                    WiseLog.d("get install begin time error !!" + re.getMessage());
                }
                catch (Exception e) {
                    WiseLog.d("exception occurs !!" + e.getMessage());
                }
            }

            public void onInstallReferrerServiceDisconnected() {
                WiseLog.d("onInstallReferrerServiceDisconnected !!");
            }
        });
    }
}

