/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.mapper.helper.impl;

import com.sdicons.json.mapper.MapperException;
import com.sdicons.json.mapper.helper.SimpleMapperHelper;
import com.sdicons.json.model.JSONDecimal;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import java.math.BigDecimal;

public class FloatMapper
implements SimpleMapperHelper {
    public Class getHelpedClass() {
        return Float.class;
    }

    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (aValue.isString()) {
            try {
                return Float.valueOf(Float.parseFloat(((JSONString)aValue).getValue()));
            }
            catch (NumberFormatException e) {
                throw new MapperException("FloatMapper cannot map value: " + ((JSONString)aValue).getValue());
            }
        }
        if (aValue.isDecimal()) {
            return Float.valueOf(((JSONDecimal)aValue).getValue().floatValue());
        }
        throw new MapperException("FloatMapper cannot map: " + aValue.getClass().getName());
    }

    public JSONValue toJSON(Object aPojo) throws MapperException {
        if (!Float.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("FloatMapper cannot map: " + aPojo.getClass().getName());
        }
        return new JSONDecimal(new BigDecimal(aPojo.toString()));
    }
}

