/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.micrometer;

import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareAsyncProcessor;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareSyncProcessor;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.session.throttling.ConcurrencyLimitingRequestThrottler;
import com.datastax.oss.driver.internal.core.session.throttling.RateLimitingRequestThrottler;
import com.datastax.oss.driver.internal.metrics.micrometer.MicrometerMetricUpdater;
import com.datastax.oss.driver.shaded.guava.common.cache.Cache;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerSessionMetricUpdater
extends MicrometerMetricUpdater<SessionMetric>
implements SessionMetricUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(MicrometerSessionMetricUpdater.class);
    private final String metricNamePrefix;

    public MicrometerSessionMetricUpdater(Set<SessionMetric> enabledMetrics, MeterRegistry registry, DriverContext driverContext) {
        super(enabledMetrics, registry);
        InternalDriverContext context = (InternalDriverContext)driverContext;
        this.metricNamePrefix = context.getSessionName() + ".";
        if (enabledMetrics.contains(DefaultSessionMetric.CONNECTED_NODES)) {
            this.registerConnectedNodeGauge(context);
        }
        if (enabledMetrics.contains(DefaultSessionMetric.THROTTLING_QUEUE_SIZE)) {
            this.registerThrottlingQueueGauge(context);
        }
        if (enabledMetrics.contains(DefaultSessionMetric.CQL_PREPARED_CACHE_SIZE)) {
            this.registerPreparedCacheGauge(context);
        }
        this.initializeTimer(DefaultSessionMetric.CQL_REQUESTS, context.getConfig().getDefaultProfile());
        this.initializeDefaultCounter(DefaultSessionMetric.CQL_CLIENT_TIMEOUTS, null);
        this.initializeTimer(DefaultSessionMetric.THROTTLING_DELAY, context.getConfig().getDefaultProfile());
        this.initializeDefaultCounter(DefaultSessionMetric.THROTTLING_ERRORS, null);
        this.initializeTimer(DseSessionMetric.CONTINUOUS_CQL_REQUESTS, context.getConfig().getDefaultProfile());
        this.initializeDefaultCounter(DseSessionMetric.GRAPH_CLIENT_TIMEOUTS, null);
        this.initializeTimer(DseSessionMetric.GRAPH_REQUESTS, context.getConfig().getDefaultProfile());
    }

    private void registerConnectedNodeGauge(InternalDriverContext context) {
        this.registry.gauge(this.buildFullName((SessionMetric)DefaultSessionMetric.CONNECTED_NODES, (String)null), (Object)context, c -> {
            int count = 0;
            for (Node node : c.getMetadataManager().getMetadata().getNodes().values()) {
                if (node.getOpenConnections() <= 0) continue;
                ++count;
            }
            return count;
        });
    }

    private void registerThrottlingQueueGauge(InternalDriverContext context) {
        this.registry.gauge(this.buildFullName((SessionMetric)DefaultSessionMetric.THROTTLING_QUEUE_SIZE, (String)null), (Object)context, c -> {
            RequestThrottler requestThrottler = c.getRequestThrottler();
            String logPrefix = c.getSessionName();
            if (requestThrottler instanceof ConcurrencyLimitingRequestThrottler) {
                return ((ConcurrencyLimitingRequestThrottler)requestThrottler).getQueueSize();
            }
            if (requestThrottler instanceof RateLimitingRequestThrottler) {
                return ((RateLimitingRequestThrottler)requestThrottler).getQueueSize();
            }
            LOG.warn("[{}] Metric {} does not support {}, it will always return 0", new Object[]{logPrefix, DefaultSessionMetric.THROTTLING_QUEUE_SIZE.getPath(), requestThrottler.getClass().getName()});
            return 0.0;
        });
    }

    private void registerPreparedCacheGauge(InternalDriverContext context) {
        this.registry.gauge(this.buildFullName((SessionMetric)DefaultSessionMetric.CQL_PREPARED_CACHE_SIZE, (String)null), (Object)context, c -> {
            Cache<?, ?> cache = MicrometerSessionMetricUpdater.getPreparedStatementCache(c);
            if (cache == null) {
                LOG.warn("[{}] Metric {} is enabled in the config, but it looks like no CQL prepare processor is registered. The gauge will always return 0", (Object)context.getSessionName(), (Object)DefaultSessionMetric.CQL_PREPARED_CACHE_SIZE.getPath());
                return 0.0;
            }
            return cache.size();
        });
    }

    @Override
    public String buildFullName(SessionMetric metric, String profileName) {
        return this.metricNamePrefix + metric.getPath();
    }

    @Nullable
    private static Cache<?, ?> getPreparedStatementCache(InternalDriverContext context) {
        for (RequestProcessor processor : context.getRequestProcessorRegistry().getProcessors()) {
            if (processor instanceof CqlPrepareAsyncProcessor) {
                return ((CqlPrepareAsyncProcessor)processor).getCache();
            }
            if (!(processor instanceof CqlPrepareSyncProcessor)) continue;
            return ((CqlPrepareSyncProcessor)processor).getCache();
        }
        return null;
    }
}

