/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.micrometer;

import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.metrics.micrometer.MicrometerMetricUpdater;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class MicrometerNodeMetricUpdater
extends MicrometerMetricUpdater<NodeMetric>
implements NodeMetricUpdater {
    private final String metricNamePrefix;
    private final Runnable signalMetricUpdated;

    public MicrometerNodeMetricUpdater(Node node, Set<NodeMetric> enabledMetrics, MeterRegistry registry, DriverContext driverContext, Runnable signalMetricUpdated) {
        super(enabledMetrics, registry);
        this.signalMetricUpdated = signalMetricUpdated;
        InternalDriverContext context = (InternalDriverContext)driverContext;
        this.metricNamePrefix = this.buildPrefix(driverContext.getSessionName(), node.getEndPoint());
        DriverExecutionProfile config = driverContext.getConfig().getDefaultProfile();
        if (enabledMetrics.contains(DefaultNodeMetric.OPEN_CONNECTIONS)) {
            this.registry.gauge(this.buildFullName((NodeMetric)DefaultNodeMetric.OPEN_CONNECTIONS, (String)null), (Number)node.getOpenConnections());
        }
        this.initializePoolGauge((NodeMetric)DefaultNodeMetric.AVAILABLE_STREAMS, node, ChannelPool::getAvailableIds, context);
        this.initializePoolGauge((NodeMetric)DefaultNodeMetric.IN_FLIGHT, node, ChannelPool::getInFlight, context);
        this.initializePoolGauge((NodeMetric)DefaultNodeMetric.ORPHANED_STREAMS, node, ChannelPool::getOrphanedIds, context);
        this.initializeTimer(DefaultNodeMetric.CQL_MESSAGES, config);
        this.initializeDefaultCounter(DefaultNodeMetric.UNSENT_REQUESTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.ABORTED_REQUESTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.WRITE_TIMEOUTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.READ_TIMEOUTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.UNAVAILABLES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.OTHER_ERRORS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_ABORTED, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_ABORTED, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_UNAVAILABLE, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_OTHER_ERROR, null);
        this.initializeDefaultCounter(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.CONNECTION_INIT_ERRORS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.AUTHENTICATION_ERRORS, null);
        this.initializeTimer(DseNodeMetric.GRAPH_MESSAGES, driverContext.getConfig().getDefaultProfile());
    }

    @Override
    public String buildFullName(NodeMetric metric, String profileName) {
        return this.metricNamePrefix + metric.getPath();
    }

    private String buildPrefix(String sessionName, EndPoint endPoint) {
        return sessionName + ".nodes." + endPoint.asMetricPrefix() + ".";
    }

    @Override
    public void incrementCounter(NodeMetric metric, String profileName, long amount) {
        this.signalMetricUpdated.run();
        super.incrementCounter(metric, profileName, amount);
    }

    @Override
    public void updateHistogram(NodeMetric metric, String profileName, long value) {
        this.signalMetricUpdated.run();
        super.updateHistogram(metric, profileName, value);
    }

    @Override
    public void markMeter(NodeMetric metric, String profileName, long amount) {
        this.signalMetricUpdated.run();
        super.markMeter(metric, profileName, amount);
    }

    @Override
    public void updateTimer(NodeMetric metric, String profileName, long duration, TimeUnit unit) {
        this.signalMetricUpdated.run();
        super.updateTimer(metric, profileName, duration, unit);
    }

    private void initializePoolGauge(NodeMetric metric, Node node, Function<ChannelPool, Integer> reading, InternalDriverContext context) {
        if (this.enabledMetrics.contains(metric)) {
            String metricName = this.buildFullName(metric, (String)null);
            this.registry.gauge(metricName, (Object)context, c -> {
                ChannelPool pool = (ChannelPool)c.getPoolManager().getPools().get(node);
                return pool == null ? 0.0 : (double)((Integer)reading.apply(pool)).intValue();
            });
        }
    }

    public void cleanupNodeMetrics() {
        this.registry.getMeters().removeIf(metric -> metric.getId().getName().startsWith(this.metricNamePrefix));
    }
}

