/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.mapper;

import com.datastax.oss.driver.internal.core.util.concurrent.LazyReference;
import com.datastax.oss.driver.internal.mapper.DaoCacheKey;
import com.datastax.oss.driver.internal.mapper.DefaultMapperContext;
import com.datastax.oss.driver.internal.mapper.processor.GeneratedNames;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.SingleFileCodeGenerator;
import com.datastax.oss.driver.internal.mapper.processor.mapper.MapperImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.util.NameIndex;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class MapperImplementationGenerator
extends SingleFileCodeGenerator
implements MapperImplementationSharedCode {
    private final TypeElement interfaceElement;
    private final ClassName className;
    private final NameIndex nameIndex = new NameIndex();
    private final List<DaoSimpleField> daoSimpleFields = new ArrayList<DaoSimpleField>();
    private final List<DaoMapField> daoMapFields = new ArrayList<DaoMapField>();

    public MapperImplementationGenerator(TypeElement interfaceElement, ProcessorContext context) {
        super(context);
        this.interfaceElement = interfaceElement;
        this.className = GeneratedNames.mapperImplementation(interfaceElement);
    }

    @Override
    public String addDaoSimpleField(String suggestedFieldName, TypeName fieldType, TypeName daoImplementationType, boolean isAsync) {
        String fieldName = this.nameIndex.uniqueField(suggestedFieldName);
        this.daoSimpleFields.add(new DaoSimpleField(fieldName, fieldType, daoImplementationType, isAsync));
        return fieldName;
    }

    @Override
    public String addDaoMapField(String suggestedFieldName, TypeName mapValueType) {
        String fieldName = this.nameIndex.uniqueField(suggestedFieldName);
        this.daoMapFields.add(new DaoMapField(fieldName, mapValueType));
        return fieldName;
    }

    @Override
    protected ClassName getPrincipalTypeName() {
        return this.className;
    }

    @Override
    protected JavaFile.Builder getContents() {
        TypeSpec.Builder classContents = TypeSpec.classBuilder((ClassName)this.className).addJavadoc("Do not instantiate this class directly, use {@link $T} instead.", new Object[]{GeneratedNames.mapperBuilder(this.interfaceElement)}).addJavadoc("\n\n<p>", new Object[0]).addJavadoc("Generated by the DataStax driver mapper, do not edit directly.\n", new Object[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"all\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get((TypeElement)this.interfaceElement));
        for (Element element : this.interfaceElement.getEnclosedElements()) {
            ExecutableElement executableElement;
            Set<Modifier> modifiers;
            if (element.getKind() != ElementKind.METHOD || (modifiers = (executableElement = (ExecutableElement)element).getModifiers()).contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.DEFAULT)) continue;
            Optional<MethodGenerator> maybeGenerator = this.context.getCodeGeneratorFactory().newMapperImplementationMethod(executableElement, this.interfaceElement, this);
            if (!maybeGenerator.isPresent()) {
                this.context.getMessager().error(executableElement, "Unrecognized method signature: no implementation will be generated", new Object[0]);
                continue;
            }
            maybeGenerator.flatMap(MethodGenerator::generate).ifPresent(arg_0 -> ((TypeSpec.Builder)classContents).addMethod(arg_0));
        }
        MethodSpec.Builder constructorContents = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        GeneratedCodePatterns.addFinalFieldAndConstructorArgument((TypeName)ClassName.get(DefaultMapperContext.class), "context", classContents, constructorContents);
        for (DaoSimpleField daoSimpleField : this.daoSimpleFields) {
            classContents.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(LazyReference.class), (TypeName[])new TypeName[]{daoSimpleField.type}), (String)daoSimpleField.name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            constructorContents.addStatement("this.$1L = new $2T<>(() -> $3T.$4L(context))", new Object[]{daoSimpleField.name, LazyReference.class, daoSimpleField.daoImplementationType, daoSimpleField.isAsync ? "initAsync" : "init"});
        }
        for (DaoMapField daoMapField : this.daoMapFields) {
            classContents.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ConcurrentMap.class), (TypeName[])new TypeName[]{TypeName.get(DaoCacheKey.class), daoMapField.mapValueType}), (String)daoMapField.name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T<>()", new Object[]{ConcurrentHashMap.class}).build());
        }
        classContents.addMethod(constructorContents.build());
        return JavaFile.builder((String)this.className.packageName(), (TypeSpec)classContents.build());
    }

    private static class DaoMapField {
        final String name;
        final TypeName mapValueType;

        DaoMapField(String name, TypeName mapValueType) {
            this.name = name;
            this.mapValueType = mapValueType;
        }
    }

    private static class DaoSimpleField {
        final String name;
        final TypeName type;
        final TypeName daoImplementationType;
        final boolean isAsync;

        DaoSimpleField(String name, TypeName type, TypeName daoImplementationType, boolean isAsync) {
            this.name = name;
            this.type = type;
            this.daoImplementationType = daoImplementationType;
            this.isAsync = isAsync;
        }
    }
}

