/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Increment;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class DaoIncrementMethodGenerator
extends DaoMethodGenerator {
    public DaoIncrementMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, TypeElement processedType, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, processedType, enclosingClass, context);
    }

    protected Set<DaoReturnTypeKind> getSupportedReturnTypes() {
        return ImmutableSet.of((Object)DefaultDaoReturnTypeKind.VOID, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_VOID, (Object)DefaultDaoReturnTypeKind.REACTIVE_RESULT_SET);
    }

    @Override
    public boolean requiresReactive() {
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Increment.class.getSimpleName());
        if (returnType == null) {
            return false;
        }
        return returnType.requiresReactive();
    }

    @Override
    public Optional<MethodSpec> generate() {
        List<? extends VariableElement> primaryKeyParameters;
        TypeElement entityElement = this.getEntityClassFromAnnotation(Increment.class);
        if (entityElement == null) {
            this.context.getMessager().error(this.methodElement, "Missing entity class: %s methods must always have an 'entityClass' argument", Increment.class.getSimpleName());
            return Optional.empty();
        }
        EntityDefinition entityDefinition = this.context.getEntityFactory().getDefinition(entityElement);
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        VariableElement boundStatementFunction = this.findBoundStatementFunction(this.methodElement);
        if (boundStatementFunction != null) {
            parameters = parameters.subList(0, parameters.size() - 1);
        }
        if ((primaryKeyParameters = parameters).size() < entityDefinition.getPrimaryKey().size()) {
            List primaryKeyTypes = entityDefinition.getPrimaryKey().stream().map(d -> d.getType().asTypeName()).collect(Collectors.toList());
            this.context.getMessager().error(this.methodElement, "Invalid parameter list: %s methods must specify the entire primary key (expected primary keys of %s: %s)", Increment.class.getSimpleName(), entityElement.getSimpleName(), primaryKeyTypes);
            return Optional.empty();
        }
        primaryKeyParameters = primaryKeyParameters.subList(0, entityDefinition.getPrimaryKey().size());
        this.warnIfCqlNamePresent(primaryKeyParameters);
        if (!EntityUtils.areParametersValid(entityElement, entityDefinition, primaryKeyParameters, Increment.class, this.context, this.methodElement, this.processedType, "")) {
            return Optional.empty();
        }
        List<? extends VariableElement> incrementParameters = parameters.subList(primaryKeyParameters.size(), parameters.size());
        if (!this.validateCqlNamesPresent(incrementParameters)) {
            return Optional.empty();
        }
        for (VariableElement variableElement : incrementParameters) {
            TypeMirror type = variableElement.asType();
            if (type.getKind() == TypeKind.LONG || this.context.getClassUtils().isSame(type, Long.class)) continue;
            this.context.getMessager().error(this.methodElement, "Invalid argument type: increment parameters of %s methods can only be primitive longs or java.lang.Long. Offending parameter: '%s' (%s)", Increment.class.getSimpleName(), variableElement.getSimpleName(), type);
            return Optional.empty();
        }
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Increment.class.getSimpleName());
        if (returnType == null) {
            return Optional.empty();
        }
        String string = this.enclosingClass.addEntityHelperField(ClassName.get((TypeElement)entityElement));
        String statementName = this.enclosingClass.addPreparedStatement(this.methodElement, (methodBuilder, requestName) -> this.generatePrepareRequest((MethodSpec.Builder)methodBuilder, (String)requestName, entityDefinition, helperFieldName, incrementParameters));
        CodeBlock.Builder updateStatementBlock = CodeBlock.builder();
        updateStatementBlock.addStatement("$T boundStatementBuilder = $L.boundStatementBuilder()", new Object[]{BoundStatementBuilder.class, statementName});
        this.populateBuilderWithStatementAttributes(updateStatementBlock, this.methodElement);
        this.populateBuilderWithFunction(updateStatementBlock, boundStatementFunction);
        List<CodeBlock> bindMarkerNames = incrementParameters.stream().map(p -> CodeBlock.of((String)"$S", (Object[])new Object[]{p.getSimpleName()})).collect(Collectors.toList());
        updateStatementBlock.addStatement("final $1T nullSavingStrategy = $1T.$2L", new Object[]{NullSavingStrategy.class, NullSavingStrategy.DO_NOT_SET});
        GeneratedCodePatterns.bindParameters(incrementParameters, bindMarkerNames, updateStatementBlock, this.enclosingClass, this.context, true);
        List<CodeBlock> primaryKeyNames = entityDefinition.getPrimaryKey().stream().map(PropertyDefinition::getCqlName).collect(Collectors.toList());
        GeneratedCodePatterns.bindParameters(primaryKeyParameters, primaryKeyNames, updateStatementBlock, this.enclosingClass, this.context, false);
        updateStatementBlock.addStatement("$T boundStatement = boundStatementBuilder.build()", new Object[]{BoundStatement.class});
        return this.crudMethod(updateStatementBlock, returnType, string);
    }

    private void generatePrepareRequest(MethodSpec.Builder methodBuilder, String requestName, EntityDefinition entityDefinition, String helperFieldName, List<? extends VariableElement> incrementParameters) {
        if (incrementParameters.isEmpty()) {
            this.context.getMessager().error(this.methodElement, "%s method must take at least one parameter representing an increment to a counter column", Increment.class.getSimpleName());
            return;
        }
        methodBuilder.addStatement("$L.throwIfKeyspaceMissing()", new Object[]{helperFieldName}).addCode("$[$1T $2L = (($3L.getKeyspaceId() == null)\n? $4T.update($3L.getTableId())\n: $4T.update($3L.getKeyspaceId(), $3L.getTableId()))", new Object[]{SimpleStatement.class, requestName, helperFieldName, QueryBuilder.class});
        for (VariableElement variableElement : incrementParameters) {
            CodeBlock cqlName = null;
            CqlName annotation = variableElement.getAnnotation(CqlName.class);
            if (annotation != null) {
                cqlName = CodeBlock.of((String)"$S", (Object[])new Object[]{annotation.value()});
            } else {
                for (PropertyDefinition property : entityDefinition.getRegularColumns()) {
                    if (!property.getJavaName().equals(variableElement.getSimpleName().toString())) continue;
                    cqlName = property.getCqlName();
                    break;
                }
                if (cqlName == null) {
                    List javaNames = StreamSupport.stream(entityDefinition.getRegularColumns().spliterator(), false).map(PropertyDefinition::getJavaName).collect(Collectors.toList());
                    this.context.getMessager().error(variableElement, "Could not match '%s' with any counter column in %s (expected one of: %s). You can also specify a CQL name directly with @%s.", variableElement.getSimpleName(), entityDefinition.getClassName().simpleName(), javaNames, CqlName.class.getSimpleName());
                    break;
                }
            }
            String bindMarkerName = variableElement.getSimpleName().toString();
            methodBuilder.addCode("\n.append($1L, $2T.bindMarker($3S))", new Object[]{cqlName, QueryBuilder.class, bindMarkerName});
        }
        for (PropertyDefinition propertyDefinition : entityDefinition.getPrimaryKey()) {
            methodBuilder.addCode("\n.where($1T.column($2L).isEqualTo($3T.bindMarker($2L)))", new Object[]{Relation.class, propertyDefinition.getCqlName(), QueryBuilder.class});
        }
        methodBuilder.addCode("\n.build()$];\n", new Object[0]);
    }
}

