/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session;

import com.datastax.oss.driver.api.core.AsyncAutoCloseable;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.LifecycleListener;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.NodeStateManager;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.session.PoolManager;
import com.datastax.oss.driver.internal.core.session.RepreparePayload;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.session.RequestProcessorRegistry;
import com.datastax.oss.driver.internal.core.session.SchemaListenerNotifier;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.core.util.concurrent.RunOrSchedule;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.util.concurrent.EventExecutor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultSession
implements CqlSession {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSession.class);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    private final InternalDriverContext context;
    private final EventExecutor adminExecutor;
    private final String logPrefix;
    private final SingleThreaded singleThreaded;
    private final MetadataManager metadataManager;
    private final RequestProcessorRegistry processorRegistry;
    private final PoolManager poolManager;
    private final SessionMetricUpdater metricUpdater;

    public static CompletionStage<CqlSession> init(InternalDriverContext context, Set<EndPoint> contactPoints, CqlIdentifier keyspace) {
        return new DefaultSession(context, contactPoints).init(keyspace);
    }

    private DefaultSession(InternalDriverContext context, Set<EndPoint> contactPoints) {
        int instanceCount = INSTANCE_COUNT.incrementAndGet();
        int threshold = context.getConfig().getDefaultProfile().getInt(DefaultDriverOption.SESSION_LEAK_THRESHOLD);
        LOG.debug("Creating new session {} ({} live instances)", (Object)context.getSessionName(), (Object)instanceCount);
        if (threshold > 0 && instanceCount > threshold) {
            LOG.warn("You have too many session instances: {} active, expected less than {} (see '{}' in the configuration)", new Object[]{instanceCount, threshold, DefaultDriverOption.SESSION_LEAK_THRESHOLD.getPath()});
        }
        this.logPrefix = context.getSessionName();
        this.adminExecutor = context.getNettyOptions().adminEventExecutorGroup().next();
        try {
            this.context = context;
            this.singleThreaded = new SingleThreaded(context, contactPoints);
            this.metadataManager = context.getMetadataManager();
            this.processorRegistry = context.getRequestProcessorRegistry();
            this.poolManager = context.getPoolManager();
            this.metricUpdater = context.getMetricsFactory().getSessionUpdater();
        }
        catch (Throwable t) {
            LOG.debug("Error creating session {} ({} live instances)", (Object)context.getSessionName(), (Object)INSTANCE_COUNT.decrementAndGet());
            try {
                context.getNettyOptions().onClose().getNow();
            }
            catch (Throwable suppressed) {
                Loggers.warnWithException(LOG, "[{}] Error while closing NettyOptions (suppressed because we're already handling an init failure)", this.logPrefix, suppressed);
            }
            throw t;
        }
    }

    private CompletionStage<CqlSession> init(CqlIdentifier keyspace) {
        RunOrSchedule.on(this.adminExecutor, () -> this.singleThreaded.init(keyspace));
        return this.singleThreaded.initFuture;
    }

    @Override
    @NonNull
    public String getName() {
        return this.context.getSessionName();
    }

    @Override
    @NonNull
    public Metadata getMetadata() {
        return this.metadataManager.getMetadata();
    }

    @Override
    public boolean isSchemaMetadataEnabled() {
        return this.metadataManager.isSchemaEnabled();
    }

    @Override
    @NonNull
    public CompletionStage<Metadata> setSchemaMetadataEnabled(@Nullable Boolean newValue) {
        return this.metadataManager.setSchemaEnabled(newValue);
    }

    @Override
    @NonNull
    public CompletionStage<Metadata> refreshSchemaAsync() {
        return this.metadataManager.refreshSchema(null, true, true).thenApply(MetadataManager.RefreshSchemaResult::getMetadata);
    }

    @Override
    @NonNull
    public CompletionStage<Boolean> checkSchemaAgreementAsync() {
        return this.context.getTopologyMonitor().checkSchemaAgreement();
    }

    @Override
    @NonNull
    public DriverContext getContext() {
        return this.context;
    }

    @Override
    @NonNull
    public Optional<CqlIdentifier> getKeyspace() {
        return Optional.ofNullable(this.poolManager.getKeyspace());
    }

    @Override
    @NonNull
    public Optional<Metrics> getMetrics() {
        return this.context.getMetricsFactory().getMetrics();
    }

    @NonNull
    public CompletionStage<Void> setKeyspace(@NonNull CqlIdentifier newKeyspace) {
        return this.poolManager.setKeyspace(newKeyspace);
    }

    @NonNull
    public Map<Node, ChannelPool> getPools() {
        return this.poolManager.getPools();
    }

    @Override
    @Nullable
    public <RequestT extends Request, ResultT> ResultT execute(@NonNull RequestT request, @NonNull GenericType<ResultT> resultType) {
        RequestProcessor<RequestT, ResultT> processor = this.processorRegistry.processorFor(request, resultType);
        return this.isClosed() ? processor.newFailure(new IllegalStateException("Session is closed")) : processor.process(request, this, this.context, this.logPrefix);
    }

    @Nullable
    public DriverChannel getChannel(@NonNull Node node, @NonNull String logPrefix) {
        return this.getChannel(node, logPrefix, null);
    }

    @Nullable
    public DriverChannel getChannel(@NonNull Node node, @NonNull String logPrefix, @Nullable Token routingKey) {
        ChannelPool pool = this.poolManager.getPools().get(node);
        if (pool == null) {
            LOG.trace("[{}] No pool to {}, skipping", (Object)logPrefix, (Object)node);
            return null;
        }
        DriverChannel channel = pool.next(routingKey);
        if (channel == null) {
            LOG.trace("[{}] Pool returned no channel for {}, skipping", (Object)logPrefix, (Object)node);
            return null;
        }
        if (channel.closeFuture().isDone()) {
            LOG.trace("[{}] Pool returned closed connection to {}, skipping", (Object)logPrefix, (Object)node);
            return null;
        }
        return channel;
    }

    @NonNull
    public ConcurrentMap<ByteBuffer, RepreparePayload> getRepreparePayloads() {
        return this.poolManager.getRepreparePayloads();
    }

    @NonNull
    public SessionMetricUpdater getMetricUpdater() {
        return this.metricUpdater;
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeFuture() {
        return this.singleThreaded.closeFuture;
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeAsync() {
        return this.closeSafely(() -> this.singleThreaded.close());
    }

    @Override
    @NonNull
    public CompletionStage<Void> forceCloseAsync() {
        return this.closeSafely(() -> this.singleThreaded.forceClose());
    }

    private CompletionStage<Void> closeSafely(Runnable action) {
        if (!this.singleThreaded.closeFuture.isDone()) {
            try {
                RunOrSchedule.on(this.adminExecutor, action);
            }
            catch (RejectedExecutionException e) {
                LOG.warn("[{}] Ignoring terminated executor. This generally happens if you close the session multiple times concurrently, and can be safely ignored if the close() call returns normally.", (Object)this.logPrefix, (Object)e);
            }
        }
        return this.singleThreaded.closeFuture;
    }

    private class SingleThreaded {
        private final InternalDriverContext context;
        private final Set<EndPoint> initialContactPoints;
        private final NodeStateManager nodeStateManager;
        private final SchemaListenerNotifier schemaListenerNotifier;
        private final CompletableFuture<CqlSession> initFuture = new CompletableFuture();
        private boolean initWasCalled;
        private final CompletableFuture<Void> closeFuture = new CompletableFuture();
        private boolean closeWasCalled;
        private boolean forceCloseWasCalled;

        private SingleThreaded(InternalDriverContext context, Set<EndPoint> contactPoints) {
            this.context = context;
            this.nodeStateManager = new NodeStateManager(context);
            this.initialContactPoints = contactPoints;
            this.schemaListenerNotifier = new SchemaListenerNotifier(context.getSchemaChangeListener(), context.getEventBus(), DefaultSession.this.adminExecutor);
            context.getEventBus().register(NodeStateEvent.class, RunOrSchedule.on(DefaultSession.this.adminExecutor, this::onNodeStateChanged));
            CompletableFutures.propagateCancellation(this.initFuture, context.getTopologyMonitor().initFuture());
        }

        private void init(CqlIdentifier keyspace) {
            assert (DefaultSession.this.adminExecutor.inEventLoop());
            if (this.initWasCalled) {
                return;
            }
            this.initWasCalled = true;
            LOG.debug("[{}] Starting initialization", (Object)DefaultSession.this.logPrefix);
            try {
                this.context.getLoadBalancingPolicies();
                this.context.getRetryPolicies();
                this.context.getSpeculativeExecutionPolicies();
                this.context.getReconnectionPolicy();
                this.context.getAddressTranslator();
                this.context.getNodeStateListener();
                this.context.getSchemaChangeListener();
                this.context.getRequestTracker();
                this.context.getRequestThrottler();
                this.context.getAuthProvider();
                this.context.getSslHandlerFactory();
                this.context.getTimestampGenerator();
            }
            catch (Throwable error2) {
                RunOrSchedule.on(DefaultSession.this.adminExecutor, this::closePolicies);
                this.context.getNettyOptions().onClose().addListener(f -> {
                    if (!f.isSuccess()) {
                        Loggers.warnWithException(LOG, "[{}] Error while closing NettyOptions (suppressed because we're already handling an init failure)", DefaultSession.this.logPrefix, f.cause());
                    }
                    this.initFuture.completeExceptionally(error2);
                });
                LOG.debug("Error initializing new session {} ({} live instances)", (Object)this.context.getSessionName(), (Object)INSTANCE_COUNT.decrementAndGet());
                return;
            }
            this.closeFuture.whenComplete((v, error) -> LOG.debug("Closing session {} ({} live instances)", (Object)this.context.getSessionName(), (Object)INSTANCE_COUNT.decrementAndGet()));
            MetadataManager metadataManager = this.context.getMetadataManager();
            metadataManager.addContactPoints(this.initialContactPoints);
            this.context.getTopologyMonitor().init().thenCompose(v -> metadataManager.refreshNodes()).thenAccept(v -> this.afterInitialNodeListRefresh(keyspace)).exceptionally(error -> {
                this.initFuture.completeExceptionally((Throwable)error);
                RunOrSchedule.on(DefaultSession.this.adminExecutor, this::close);
                return null;
            });
        }

        private void afterInitialNodeListRefresh(CqlIdentifier keyspace) {
            try {
                ProtocolVersion bestVersion;
                ProtocolVersion currentVersion;
                boolean protocolWasForced = this.context.getConfig().getDefaultProfile().isDefined(DefaultDriverOption.PROTOCOL_VERSION);
                if (!protocolWasForced && !(currentVersion = this.context.getProtocolVersion()).equals(bestVersion = this.context.getProtocolVersionRegistry().highestCommon(DefaultSession.this.metadataManager.getMetadata().getNodes().values()))) {
                    LOG.info("[{}] Negotiated protocol version {} for the initial contact point, but other nodes only support {}, downgrading", new Object[]{DefaultSession.this.logPrefix, currentVersion, bestVersion});
                    this.context.getChannelFactory().setProtocolVersion(bestVersion);
                }
                DefaultSession.this.metadataManager.refreshSchema(null, false, true).whenComplete((metadata, error) -> {
                    if (error != null) {
                        Loggers.warnWithException(LOG, "[{}] Unexpected error while refreshing schema during initialization, keeping previous version", DefaultSession.this.logPrefix, error);
                    }
                    this.afterInitialSchemaRefresh(keyspace);
                });
            }
            catch (Throwable throwable) {
                this.initFuture.completeExceptionally(throwable);
            }
        }

        private void afterInitialSchemaRefresh(CqlIdentifier keyspace) {
            try {
                this.nodeStateManager.markInitialized();
                this.context.getLoadBalancingPolicyWrapper().init();
                this.context.getConfigLoader().onDriverInit(this.context);
                LOG.debug("[{}] Initialization complete, ready", (Object)DefaultSession.this.logPrefix);
                DefaultSession.this.poolManager.init(keyspace).whenComplete((v, error) -> {
                    if (error != null) {
                        this.initFuture.completeExceptionally((Throwable)error);
                    } else {
                        this.notifyListeners();
                        this.initFuture.complete(DefaultSession.this);
                    }
                });
            }
            catch (Throwable throwable) {
                DefaultSession.this.forceCloseAsync().whenComplete((v, error) -> this.initFuture.completeExceptionally(throwable));
            }
        }

        private void notifyListeners() {
            for (LifecycleListener lifecycleListener : this.context.getLifecycleListeners()) {
                try {
                    lifecycleListener.onSessionReady();
                }
                catch (Throwable t) {
                    Loggers.warnWithException(LOG, "[{}] Error while notifying {} of session ready", DefaultSession.this.logPrefix, lifecycleListener, t);
                }
            }
            this.context.getNodeStateListener().onSessionReady(DefaultSession.this);
            this.schemaListenerNotifier.onSessionReady(DefaultSession.this);
            this.context.getRequestTracker().onSessionReady(DefaultSession.this);
        }

        private void onNodeStateChanged(NodeStateEvent event) {
            assert (DefaultSession.this.adminExecutor.inEventLoop());
            if (event.newState == null) {
                this.context.getNodeStateListener().onRemove(event.node);
            } else if (event.oldState == null && event.newState == NodeState.UNKNOWN) {
                this.context.getNodeStateListener().onAdd(event.node);
            } else if (event.newState == NodeState.UP) {
                this.context.getNodeStateListener().onUp(event.node);
            } else if (event.newState == NodeState.DOWN || event.newState == NodeState.FORCED_DOWN) {
                this.context.getNodeStateListener().onDown(event.node);
            }
        }

        private void close() {
            assert (DefaultSession.this.adminExecutor.inEventLoop());
            if (this.closeWasCalled) {
                return;
            }
            this.closeWasCalled = true;
            LOG.debug("[{}] Starting shutdown", (Object)DefaultSession.this.logPrefix);
            this.closePolicies();
            ArrayList childrenCloseStages = new ArrayList();
            for (AsyncAutoCloseable closeable : this.internalComponentsToClose()) {
                childrenCloseStages.add(closeable.closeAsync());
            }
            CompletableFutures.whenAllDone(childrenCloseStages, () -> this.onChildrenClosed(childrenCloseStages), (Executor)DefaultSession.this.adminExecutor);
        }

        private void forceClose() {
            assert (DefaultSession.this.adminExecutor.inEventLoop());
            if (this.forceCloseWasCalled) {
                return;
            }
            this.forceCloseWasCalled = true;
            LOG.debug("[{}] Starting forced shutdown (was {}closed before)", (Object)DefaultSession.this.logPrefix, (Object)(this.closeWasCalled ? "" : "not "));
            if (this.closeWasCalled) {
                for (AsyncAutoCloseable closeable : this.internalComponentsToClose()) {
                    closeable.forceCloseAsync();
                }
            } else {
                this.closePolicies();
                ArrayList childrenCloseStages = new ArrayList();
                for (AsyncAutoCloseable closeable : this.internalComponentsToClose()) {
                    childrenCloseStages.add(closeable.forceCloseAsync());
                }
                CompletableFutures.whenAllDone(childrenCloseStages, () -> this.onChildrenClosed(childrenCloseStages), (Executor)DefaultSession.this.adminExecutor);
            }
        }

        private void onChildrenClosed(List<CompletionStage<Void>> childrenCloseStages) {
            assert (DefaultSession.this.adminExecutor.inEventLoop());
            for (CompletionStage<Void> stage : childrenCloseStages) {
                this.warnIfFailed(stage);
            }
            this.context.getNettyOptions().onClose().addListener(f -> {
                if (!f.isSuccess()) {
                    this.closeFuture.completeExceptionally(f.cause());
                } else {
                    this.closeFuture.complete(null);
                }
            });
        }

        private void warnIfFailed(CompletionStage<Void> stage) {
            CompletableFuture<Void> future = stage.toCompletableFuture();
            assert (future.isDone());
            if (future.isCompletedExceptionally()) {
                Loggers.warnWithException(LOG, "[{}] Unexpected error while closing", DefaultSession.this.logPrefix, CompletableFutures.getFailed(future));
            }
        }

        private void closePolicies() {
            ArrayList<AutoCloseable> policies = new ArrayList<AutoCloseable>();
            for (Supplier supplier : ImmutableList.of(this.context::getReconnectionPolicy, this.context::getLoadBalancingPolicyWrapper, this.context::getAddressTranslator, this.context::getConfigLoader, this.context::getNodeStateListener, this.context::getSchemaChangeListener, this.context::getRequestTracker, this.context::getRequestThrottler, this.context::getTimestampGenerator)) {
                try {
                    policies.add((AutoCloseable)supplier.get());
                }
                catch (Throwable throwable) {}
            }
            try {
                this.context.getAuthProvider().ifPresent(policies::add);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.context.getSslHandlerFactory().ifPresent(policies::add);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                policies.addAll(this.context.getRetryPolicies().values());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                policies.addAll(this.context.getSpeculativeExecutionPolicies().values());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            policies.addAll(this.context.getLifecycleListeners());
            for (AutoCloseable policy : policies) {
                try {
                    policy.close();
                }
                catch (Throwable t) {
                    Loggers.warnWithException(LOG, "[{}] Error while closing {}", DefaultSession.this.logPrefix, policy, t);
                }
            }
        }

        private List<AsyncAutoCloseable> internalComponentsToClose() {
            ImmutableList.Builder components = ImmutableList.builder().add((Object[])new AsyncAutoCloseable[]{DefaultSession.this.poolManager, this.nodeStateManager, DefaultSession.this.metadataManager});
            try {
                components.add((Object)this.context.getTopologyMonitor());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                components.add((Object)this.context.getControlConnection());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return components.build();
        }
    }
}

