/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.RoutingKey;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public interface Statement<SelfT extends Statement<SelfT>>
extends Request {
    public static final GenericType<ResultSet> SYNC = GenericType.of(ResultSet.class);
    public static final GenericType<CompletionStage<AsyncResultSet>> ASYNC = new GenericType<CompletionStage<AsyncResultSet>>(){};
    public static final long NO_DEFAULT_TIMESTAMP = Long.MIN_VALUE;
    public static final int NO_NOW_IN_SECONDS = Integer.MIN_VALUE;

    @NonNull
    @CheckReturnValue
    public SelfT setExecutionProfileName(@Nullable String var1);

    @NonNull
    @CheckReturnValue
    public SelfT setExecutionProfile(@Nullable DriverExecutionProfile var1);

    @NonNull
    @CheckReturnValue
    public SelfT setRoutingKeyspace(@Nullable CqlIdentifier var1);

    @NonNull
    @CheckReturnValue
    public SelfT setNode(@Nullable Node var1);

    @NonNull
    @CheckReturnValue
    default public SelfT setRoutingKeyspace(@Nullable String newRoutingKeyspaceName) {
        return this.setRoutingKeyspace(newRoutingKeyspaceName == null ? null : CqlIdentifier.fromCql(newRoutingKeyspaceName));
    }

    @NonNull
    @CheckReturnValue
    public SelfT setRoutingKey(@Nullable ByteBuffer var1);

    @NonNull
    @CheckReturnValue
    default public SelfT setRoutingKey(ByteBuffer ... newRoutingKeyComponents) {
        return this.setRoutingKey(RoutingKey.compose(newRoutingKeyComponents));
    }

    @NonNull
    @CheckReturnValue
    public SelfT setRoutingToken(@Nullable Token var1);

    @NonNull
    @CheckReturnValue
    public SelfT setCustomPayload(@NonNull Map<String, ByteBuffer> var1);

    @NonNull
    @CheckReturnValue
    public SelfT setIdempotent(@Nullable Boolean var1);

    @NonNull
    @CheckReturnValue
    public SelfT setTracing(boolean var1);

    public long getQueryTimestamp();

    @NonNull
    @CheckReturnValue
    public SelfT setQueryTimestamp(long var1);

    @NonNull
    @CheckReturnValue
    public SelfT setTimeout(@Nullable Duration var1);

    @Nullable
    public ByteBuffer getPagingState();

    @NonNull
    @CheckReturnValue
    public SelfT setPagingState(@Nullable ByteBuffer var1);

    public int getPageSize();

    @NonNull
    @CheckReturnValue
    public SelfT setPageSize(int var1);

    @Nullable
    public ConsistencyLevel getConsistencyLevel();

    @NonNull
    @CheckReturnValue
    public SelfT setConsistencyLevel(@Nullable ConsistencyLevel var1);

    @Nullable
    public ConsistencyLevel getSerialConsistencyLevel();

    @NonNull
    @CheckReturnValue
    public SelfT setSerialConsistencyLevel(@Nullable ConsistencyLevel var1);

    public boolean isTracing();

    default public int getNowInSeconds() {
        return Integer.MIN_VALUE;
    }

    @NonNull
    default public SelfT setNowInSeconds(int nowInSeconds) {
        return (SelfT)this;
    }

    public int computeSizeInBytes(@NonNull DriverContext var1);

    @NonNull
    @CheckReturnValue
    default public SelfT copy(@Nullable ByteBuffer newPagingState) {
        return this.setPagingState(newPagingState);
    }
}

