/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class MultiPageResultSet
implements ResultSet {
    private final RowIterator iterator;
    private final List<ExecutionInfo> executionInfos = new ArrayList<ExecutionInfo>();
    private ColumnDefinitions columnDefinitions;

    public MultiPageResultSet(@NonNull AsyncResultSet firstPage) {
        assert (firstPage.hasMorePages());
        this.iterator = new RowIterator(firstPage);
        this.executionInfos.add(firstPage.getExecutionInfo());
        this.columnDefinitions = firstPage.getColumnDefinitions();
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @Override
    @NonNull
    public List<ExecutionInfo> getExecutionInfos() {
        return this.executionInfos;
    }

    @Override
    public boolean isFullyFetched() {
        return this.iterator.isFullyFetched();
    }

    @Override
    public int getAvailableWithoutFetching() {
        return this.iterator.remaining();
    }

    @Override
    @NonNull
    public Iterator<Row> iterator() {
        return this.iterator;
    }

    @Override
    public boolean wasApplied() {
        return this.iterator.wasApplied();
    }

    private class RowIterator
    extends CountingIterator<Row> {
        private AsyncResultSet currentPage;
        private Iterator<Row> currentRows;

        private RowIterator(AsyncResultSet firstPage) {
            super(firstPage.remaining());
            this.currentPage = firstPage;
            this.currentRows = firstPage.currentPage().iterator();
        }

        @Override
        protected Row computeNext() {
            this.maybeMoveToNextPage();
            return this.currentRows.hasNext() ? this.currentRows.next() : (Row)this.endOfData();
        }

        private void maybeMoveToNextPage() {
            while (!this.currentRows.hasNext() && this.currentPage.hasMorePages()) {
                AsyncResultSet nextPage;
                BlockingOperation.checkNotDriverThread();
                this.currentPage = nextPage = (AsyncResultSet)CompletableFutures.getUninterruptibly(this.currentPage.fetchNextPage());
                this.remaining += nextPage.remaining();
                this.currentRows = nextPage.currentPage().iterator();
                MultiPageResultSet.this.executionInfos.add(nextPage.getExecutionInfo());
                MultiPageResultSet.this.columnDefinitions = nextPage.getColumnDefinitions();
            }
        }

        private boolean isFullyFetched() {
            return !this.currentPage.hasMorePages();
        }

        private boolean wasApplied() {
            return this.currentPage.wasApplied();
        }
    }
}

