/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.servererrors;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.QueryConsistencyException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class WriteTimeoutException
extends QueryConsistencyException {
    private final WriteType writeType;

    public WriteTimeoutException(@NonNull Node coordinator, @NonNull ConsistencyLevel consistencyLevel, int received, int blockFor, @NonNull WriteType writeType) {
        this(coordinator, String.format("Cassandra timeout during %s write query at consistency %s (%d replica were required but only %d acknowledged the write)", writeType, consistencyLevel, blockFor, received), consistencyLevel, received, blockFor, writeType, null, false);
    }

    private WriteTimeoutException(@NonNull Node coordinator, @NonNull String message, @NonNull ConsistencyLevel consistencyLevel, int received, int blockFor, @NonNull WriteType writeType, @Nullable ExecutionInfo executionInfo, boolean writableStackTrace) {
        super(coordinator, message, consistencyLevel, received, blockFor, executionInfo, writableStackTrace);
        this.writeType = writeType;
    }

    @NonNull
    public WriteType getWriteType() {
        return this.writeType;
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new WriteTimeoutException(this.getCoordinator(), this.getMessage(), this.getConsistencyLevel(), this.getReceived(), this.getBlockFor(), this.writeType, this.getExecutionInfo(), true);
    }
}

