/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphExecutionInfo;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.api.core.graph.GraphResultSet;
import com.datastax.dse.driver.internal.core.graph.GraphExecutionInfoConverter;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiPageGraphResultSet
implements GraphResultSet {
    private final RowIterator iterator;
    private final List<ExecutionInfo> executionInfos = new ArrayList<ExecutionInfo>();

    public MultiPageGraphResultSet(AsyncGraphResultSet firstPage) {
        this.iterator = new RowIterator(firstPage);
        this.executionInfos.add(firstPage.getRequestExecutionInfo());
    }

    @Override
    public void cancel() {
        this.iterator.cancel();
    }

    @Override
    @NonNull
    public ExecutionInfo getRequestExecutionInfo() {
        return this.executionInfos.get(this.executionInfos.size() - 1);
    }

    @Override
    @Deprecated
    @NonNull
    public GraphExecutionInfo getExecutionInfo() {
        return GraphExecutionInfoConverter.convert(this.getRequestExecutionInfo());
    }

    @NonNull
    public List<ExecutionInfo> getRequestExecutionInfos() {
        return this.executionInfos;
    }

    @Deprecated
    @NonNull
    public List<GraphExecutionInfo> getExecutionInfos() {
        return Lists.transform(this.executionInfos, GraphExecutionInfoConverter::convert);
    }

    @Override
    @NonNull
    public Iterator<GraphNode> iterator() {
        return this.iterator;
    }

    public class RowIterator
    extends CountingIterator<GraphNode> {
        private AsyncGraphResultSet currentPage;
        private Iterator<GraphNode> currentRows;
        private boolean cancelled;

        private RowIterator(AsyncGraphResultSet firstPage) {
            super(firstPage.remaining());
            this.cancelled = false;
            this.currentPage = firstPage;
            this.currentRows = firstPage.currentPage().iterator();
        }

        @Override
        protected GraphNode computeNext() {
            this.maybeMoveToNextPage();
            return this.currentRows.hasNext() ? this.currentRows.next() : (GraphNode)this.endOfData();
        }

        private void maybeMoveToNextPage() {
            if (!this.cancelled && !this.currentRows.hasNext() && this.currentPage.hasMorePages()) {
                AsyncGraphResultSet nextPage;
                BlockingOperation.checkNotDriverThread();
                this.currentPage = nextPage = CompletableFutures.getUninterruptibly(this.currentPage.fetchNextPage());
                this.remaining += this.currentPage.remaining();
                this.currentRows = nextPage.currentPage().iterator();
                MultiPageGraphResultSet.this.executionInfos.add(nextPage.getRequestExecutionInfo());
            }
        }

        private void cancel() {
            this.currentPage.cancel();
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

