/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry.ogc;

import com.datastax.oss.driver.shaded.esri.core.geometry.Geometry;
import com.datastax.oss.driver.shaded.esri.core.geometry.GeometryEngine;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiPoint;
import com.datastax.oss.driver.shaded.esri.core.geometry.Operator;
import com.datastax.oss.driver.shaded.esri.core.geometry.OperatorExportToWkb;
import com.datastax.oss.driver.shaded.esri.core.geometry.OperatorFactoryLocal;
import com.datastax.oss.driver.shaded.esri.core.geometry.Point;
import com.datastax.oss.driver.shaded.esri.core.geometry.SpatialReference;
import com.datastax.oss.driver.shaded.esri.core.geometry.ogc.OGCGeometry;
import com.datastax.oss.driver.shaded.esri.core.geometry.ogc.OGCGeometryCollection;
import com.datastax.oss.driver.shaded.esri.core.geometry.ogc.OGCPoint;
import java.nio.ByteBuffer;

public class OGCMultiPoint
extends OGCGeometryCollection {
    private MultiPoint multiPoint;

    @Override
    public int numGeometries() {
        return this.multiPoint.getPointCount();
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 2);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(2, this.getEsriGeometry(), null);
    }

    @Override
    public OGCGeometry geometryN(int n) {
        return OGCGeometry.createFromEsriGeometry(this.multiPoint.getPoint(n), this.esriSR);
    }

    @Override
    public String geometryType() {
        return "MultiPoint";
    }

    public OGCMultiPoint(MultiPoint mp, SpatialReference sr) {
        this.multiPoint = mp;
        this.esriSR = sr;
    }

    public OGCMultiPoint(Point startPoint, SpatialReference sr) {
        this.multiPoint = new MultiPoint();
        this.multiPoint.add(startPoint);
        this.esriSR = sr;
    }

    public OGCMultiPoint(OGCPoint startPoint, OGCPoint endPoint) {
        this.multiPoint = new MultiPoint();
        this.multiPoint.add((Point)startPoint.getEsriGeometry());
        this.multiPoint.add((Point)endPoint.getEsriGeometry());
        this.esriSR = startPoint.esriSR;
    }

    public OGCMultiPoint(SpatialReference sr) {
        this.esriSR = sr;
        this.multiPoint = new MultiPoint();
    }

    @Override
    public OGCGeometry boundary() {
        return new OGCMultiPoint((MultiPoint)this.multiPoint.createInstance(), this.esriSR);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.multiPoint;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }
}

