/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

import com.datastax.oss.driver.shaded.codehaus.jackson.JsonToken;
import com.datastax.oss.driver.shaded.esri.core.geometry.GeometryException;
import com.datastax.oss.driver.shaded.esri.core.geometry.JSONArrayEnumerator;
import com.datastax.oss.driver.shaded.esri.core.geometry.JSONObjectEnumerator;
import com.datastax.oss.driver.shaded.esri.core.geometry.JsonReader;
import com.datastax.oss.driver.shaded.json.JSONArray;
import com.datastax.oss.driver.shaded.json.JSONObject;
import java.util.ArrayList;

final class JsonValueReader
extends JsonReader {
    private Object m_object;
    private JsonToken m_currentToken;
    private ArrayList<JsonToken> m_parentStack;
    private ArrayList<JSONObjectEnumerator> m_objIters;
    private ArrayList<JSONArrayEnumerator> m_arrIters;

    JsonValueReader(Object object) {
        this.m_object = object;
        boolean bJSONObject = this.m_object instanceof JSONObject;
        boolean bJSONArray = this.m_object instanceof JSONArray;
        if (!bJSONObject && !bJSONArray) {
            throw new IllegalArgumentException();
        }
        this.m_parentStack = new ArrayList(0);
        this.m_objIters = new ArrayList(0);
        this.m_arrIters = new ArrayList(0);
        this.m_parentStack.ensureCapacity(4);
        this.m_objIters.ensureCapacity(4);
        this.m_arrIters.ensureCapacity(4);
        if (bJSONObject) {
            JSONObjectEnumerator objIter = new JSONObjectEnumerator((JSONObject)this.m_object);
            this.m_parentStack.add(JsonToken.START_OBJECT);
            this.m_objIters.add(objIter);
            this.m_currentToken = JsonToken.START_OBJECT;
        } else {
            JSONArrayEnumerator arrIter = new JSONArrayEnumerator((JSONArray)this.m_object);
            this.m_parentStack.add(JsonToken.START_ARRAY);
            this.m_arrIters.add(arrIter);
            this.m_currentToken = JsonToken.START_ARRAY;
        }
    }

    private void setCurrentToken_(Object obj) {
        Boolean bObj;
        boolean b;
        this.m_currentToken = obj instanceof String ? JsonToken.VALUE_STRING : (obj instanceof Double || obj instanceof Float ? JsonToken.VALUE_NUMBER_FLOAT : (obj instanceof Integer || obj instanceof Long || obj instanceof Short ? JsonToken.VALUE_NUMBER_INT : (obj instanceof Boolean ? ((b = (bObj = (Boolean)obj).booleanValue()) ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE) : (obj instanceof JSONObject ? JsonToken.START_OBJECT : (obj instanceof JSONArray ? JsonToken.START_ARRAY : JsonToken.VALUE_NULL)))));
    }

    Object currentObject_() {
        assert (!this.m_parentStack.isEmpty());
        JsonToken parentType = this.m_parentStack.get(this.m_parentStack.size() - 1);
        if (parentType == JsonToken.START_OBJECT) {
            JSONObjectEnumerator objIter = this.m_objIters.get(this.m_objIters.size() - 1);
            return objIter.getCurrentObject();
        }
        JSONArrayEnumerator arrIter = this.m_arrIters.get(this.m_arrIters.size() - 1);
        return arrIter.getCurrentObject();
    }

    @Override
    JsonToken nextToken() throws Exception {
        if (this.m_parentStack.isEmpty()) {
            this.m_currentToken = JsonToken.NOT_AVAILABLE;
            return this.m_currentToken;
        }
        JsonToken parentType = this.m_parentStack.get(this.m_parentStack.size() - 1);
        if (parentType == JsonToken.START_OBJECT) {
            JSONObjectEnumerator iterator = this.m_objIters.get(this.m_objIters.size() - 1);
            if (this.m_currentToken == JsonToken.FIELD_NAME) {
                Object nextJSONValue = iterator.getCurrentObject();
                if (nextJSONValue instanceof JSONObject) {
                    this.m_parentStack.add(JsonToken.START_OBJECT);
                    this.m_objIters.add(new JSONObjectEnumerator((JSONObject)nextJSONValue));
                    this.m_currentToken = JsonToken.START_OBJECT;
                } else if (nextJSONValue instanceof JSONArray) {
                    this.m_parentStack.add(JsonToken.START_ARRAY);
                    this.m_arrIters.add(new JSONArrayEnumerator((JSONArray)nextJSONValue));
                    this.m_currentToken = JsonToken.START_ARRAY;
                } else {
                    this.setCurrentToken_(nextJSONValue);
                }
            } else if (iterator.next()) {
                this.m_currentToken = JsonToken.FIELD_NAME;
            } else {
                this.m_objIters.remove(this.m_objIters.size() - 1);
                this.m_parentStack.remove(this.m_parentStack.size() - 1);
                this.m_currentToken = JsonToken.END_OBJECT;
            }
        } else {
            assert (parentType == JsonToken.START_ARRAY);
            JSONArrayEnumerator iterator = this.m_arrIters.get(this.m_arrIters.size() - 1);
            if (iterator.next()) {
                Object nextJSONValue = iterator.getCurrentObject();
                if (nextJSONValue instanceof JSONObject) {
                    this.m_parentStack.add(JsonToken.START_OBJECT);
                    this.m_objIters.add(new JSONObjectEnumerator((JSONObject)nextJSONValue));
                    this.m_currentToken = JsonToken.START_OBJECT;
                } else if (nextJSONValue instanceof JSONArray) {
                    this.m_parentStack.add(JsonToken.START_ARRAY);
                    this.m_arrIters.add(new JSONArrayEnumerator((JSONArray)nextJSONValue));
                    this.m_currentToken = JsonToken.START_ARRAY;
                } else {
                    this.setCurrentToken_(nextJSONValue);
                }
            } else {
                this.m_arrIters.remove(this.m_arrIters.size() - 1);
                this.m_parentStack.remove(this.m_parentStack.size() - 1);
                this.m_currentToken = JsonToken.END_ARRAY;
            }
        }
        return this.m_currentToken;
    }

    @Override
    JsonToken currentToken() throws Exception {
        return this.m_currentToken;
    }

    @Override
    void skipChildren() throws Exception {
        assert (!this.m_parentStack.isEmpty());
        if (this.m_currentToken != JsonToken.START_OBJECT && this.m_currentToken != JsonToken.START_ARRAY) {
            return;
        }
        JsonToken parentType = this.m_parentStack.get(this.m_parentStack.size() - 1);
        if (parentType == JsonToken.START_OBJECT) {
            this.m_objIters.remove(this.m_objIters.size() - 1);
            this.m_parentStack.remove(this.m_parentStack.size() - 1);
            this.m_currentToken = JsonToken.END_OBJECT;
        } else {
            this.m_arrIters.remove(this.m_arrIters.size() - 1);
            this.m_parentStack.remove(this.m_parentStack.size() - 1);
            this.m_currentToken = JsonToken.END_ARRAY;
        }
    }

    @Override
    String currentString() throws Exception {
        if (this.m_currentToken == JsonToken.FIELD_NAME) {
            return this.m_objIters.get(this.m_objIters.size() - 1).getCurrentKey();
        }
        if (this.m_currentToken != JsonToken.VALUE_STRING) {
            throw new GeometryException("invalid call");
        }
        return ((String)this.currentObject_()).toString();
    }

    @Override
    double currentDoubleValue() throws Exception {
        if (this.m_currentToken != JsonToken.VALUE_NUMBER_FLOAT && this.m_currentToken != JsonToken.VALUE_NUMBER_INT) {
            throw new GeometryException("invalid call");
        }
        return ((Number)this.currentObject_()).doubleValue();
    }

    @Override
    int currentIntValue() throws Exception {
        if (this.m_currentToken != JsonToken.VALUE_NUMBER_INT) {
            throw new GeometryException("invalid call");
        }
        return ((Number)this.currentObject_()).intValue();
    }
}

