/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.data.DefaultUdtValue;
import com.datastax.oss.driver.internal.core.data.IdentifierIndex;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultUserDefinedType
implements UserDefinedType,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CqlIdentifier keyspace;
    private final CqlIdentifier name;
    private final transient boolean frozen;
    private final List<CqlIdentifier> fieldNames;
    private final List<DataType> fieldTypes;
    private transient IdentifierIndex index;
    private volatile transient AttachmentPoint attachmentPoint;

    public DefaultUserDefinedType(@NonNull CqlIdentifier keyspace, @NonNull CqlIdentifier name, boolean frozen, List<CqlIdentifier> fieldNames, @NonNull List<DataType> fieldTypes, @NonNull AttachmentPoint attachmentPoint) {
        Preconditions.checkNotNull((Object)keyspace);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(fieldNames);
        Preconditions.checkNotNull(fieldTypes);
        Preconditions.checkArgument((fieldNames.size() > 0 ? 1 : 0) != 0, (Object)"Field names list can't be null or empty");
        Preconditions.checkArgument((fieldTypes.size() == fieldNames.size() ? 1 : 0) != 0, (Object)"There should be the same number of field names and types");
        this.keyspace = keyspace;
        this.name = name;
        this.frozen = frozen;
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.fieldTypes = ImmutableList.copyOf(fieldTypes);
        this.index = new IdentifierIndex(this.fieldNames);
        this.attachmentPoint = attachmentPoint;
    }

    public DefaultUserDefinedType(@NonNull CqlIdentifier keyspace, @NonNull CqlIdentifier name, boolean frozen, @NonNull List<CqlIdentifier> fieldNames, @NonNull List<DataType> fieldTypes) {
        this(keyspace, name, frozen, fieldNames, fieldTypes, AttachmentPoint.NONE);
    }

    @Override
    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @Override
    @NonNull
    public CqlIdentifier getName() {
        return this.name;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    @NonNull
    public List<CqlIdentifier> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public int firstIndexOf(@NonNull CqlIdentifier id) {
        return this.index.firstIndexOf(id);
    }

    @Override
    public int firstIndexOf(@NonNull String name) {
        return this.index.firstIndexOf(name);
    }

    @Override
    @NonNull
    public List<DataType> getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    @NonNull
    public UserDefinedType copy(boolean newFrozen) {
        return newFrozen == this.frozen ? this : new DefaultUserDefinedType(this.keyspace, this.name, newFrozen, this.fieldNames, this.fieldTypes, this.attachmentPoint);
    }

    @Override
    @NonNull
    public UdtValue newValue() {
        return new DefaultUdtValue(this);
    }

    @Override
    @NonNull
    public UdtValue newValue(Object ... fields) {
        return new DefaultUdtValue((UserDefinedType)this, fields);
    }

    @Override
    public boolean isDetached() {
        return this.attachmentPoint == AttachmentPoint.NONE;
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
        this.attachmentPoint = attachmentPoint;
        for (DataType fieldType : this.fieldTypes) {
            fieldType.attach(attachmentPoint);
        }
    }

    @Override
    @NonNull
    public AttachmentPoint getAttachmentPoint() {
        return this.attachmentPoint;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof UserDefinedType) {
            UserDefinedType that = (UserDefinedType)other;
            return this.keyspace.equals(that.getKeyspace()) && this.name.equals(that.getName()) && this.fieldNames.equals(that.getFieldNames()) && this.fieldTypes.equals(that.getFieldTypes());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.name, this.fieldNames, this.fieldTypes);
    }

    public String toString() {
        return "UDT(" + this.keyspace.asCql(true) + "." + this.name.asCql(true) + ")";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Preconditions.checkNotNull((Object)this.keyspace);
        Preconditions.checkNotNull((Object)this.name);
        Preconditions.checkArgument((this.fieldNames != null && this.fieldNames.size() > 0 ? 1 : 0) != 0, (Object)"Field names list can't be null or empty");
        Preconditions.checkArgument((this.fieldTypes != null && this.fieldTypes.size() == this.fieldNames.size() ? 1 : 0) != 0, (Object)"There should be the same number of field names and types");
        this.attachmentPoint = AttachmentPoint.NONE;
        this.index = new IdentifierIndex(this.fieldNames);
    }
}

