/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.protocol.ByteBufCompressor;
import com.datastax.oss.driver.internal.core.util.DependencyCheck;
import com.datastax.oss.driver.shaded.netty.buffer.ByteBuf;
import com.datastax.oss.driver.shaded.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;
import org.xerial.snappy.Snappy;

@ThreadSafe
public class SnappyCompressor
extends ByteBufCompressor {
    public SnappyCompressor(DriverContext context) {
        if (!DependencyCheck.SNAPPY.isPresent()) {
            throw new IllegalStateException("Could not find the Snappy library on the classpath (the driver declares it as an optional dependency, so you need to declare it explicitly)");
        }
    }

    public String algorithm() {
        return "snappy";
    }

    @Override
    protected ByteBuf compressDirect(ByteBuf input) {
        int maxCompressedLength = Snappy.maxCompressedLength((int)input.readableBytes());
        ByteBuf output = input.alloc().directBuffer(maxCompressedLength);
        try {
            ByteBuffer in = SnappyCompressor.inputNioBuffer(input);
            input.readerIndex(input.writerIndex());
            ByteBuffer out = SnappyCompressor.outputNioBuffer(output);
            int written = Snappy.compress((ByteBuffer)in, (ByteBuffer)out);
            output.writerIndex(output.writerIndex() + written);
            return output;
        }
        catch (IOException e) {
            output.release();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ByteBuf compressHeap(ByteBuf input) {
        int maxCompressedLength = Snappy.maxCompressedLength((int)input.readableBytes());
        int inOffset = input.arrayOffset() + input.readerIndex();
        byte[] in = input.array();
        int len = input.readableBytes();
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().heapBuffer(maxCompressedLength);
        try {
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int written = Snappy.compress((byte[])in, (int)inOffset, (int)len, (byte[])out, (int)offset);
            output.writerIndex(output.writerIndex() + written);
            return output;
        }
        catch (IOException e) {
            output.release();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ByteBuf decompressDirect(ByteBuf input) {
        ByteBuffer in = SnappyCompressor.inputNioBuffer(input);
        input.readerIndex(input.writerIndex());
        ReferenceCounted output = null;
        try {
            if (!Snappy.isValidCompressedBuffer((ByteBuffer)in)) {
                throw new IllegalArgumentException("Provided frame does not appear to be Snappy compressed");
            }
            output = input.alloc().directBuffer(Snappy.uncompressedLength((ByteBuffer)in));
            ByteBuffer out = SnappyCompressor.outputNioBuffer((ByteBuf)output);
            int size = Snappy.uncompress((ByteBuffer)in, (ByteBuffer)out);
            ((ByteBuf)output).writerIndex(((ByteBuf)output).writerIndex() + size);
            return output;
        }
        catch (IOException e) {
            if (output != null) {
                output.release();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ByteBuf decompressHeap(ByteBuf input) throws RuntimeException {
        int inOffset = input.arrayOffset() + input.readerIndex();
        byte[] in = input.array();
        int len = input.readableBytes();
        input.readerIndex(input.writerIndex());
        ReferenceCounted output = null;
        try {
            if (!Snappy.isValidCompressedBuffer((byte[])in, (int)inOffset, (int)len)) {
                throw new IllegalArgumentException("Provided frame does not appear to be Snappy compressed");
            }
            output = input.alloc().heapBuffer(Snappy.uncompressedLength((byte[])in, (int)inOffset, (int)len));
            int offset = ((ByteBuf)output).arrayOffset() + ((ByteBuf)output).writerIndex();
            byte[] out = ((ByteBuf)output).array();
            int written = Snappy.uncompress((byte[])in, (int)inOffset, (int)len, (byte[])out, (int)offset);
            ((ByteBuf)output).writerIndex(((ByteBuf)output).writerIndex() + written);
            return output;
        }
        catch (IOException e) {
            if (output != null) {
                output.release();
            }
            throw new RuntimeException(e);
        }
    }
}

