/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.shaded.netty.buffer.ByteBuf;
import com.datastax.oss.driver.shaded.netty.buffer.ByteBufAllocator;
import com.datastax.oss.driver.shaded.netty.buffer.CompositeByteBuf;
import com.datastax.oss.driver.shaded.netty.util.CharsetUtil;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ByteBufPrimitiveCodec
implements PrimitiveCodec<ByteBuf> {
    private final ByteBufAllocator allocator;

    public ByteBufPrimitiveCodec(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    public ByteBuf allocate(int size) {
        return this.allocator.ioBuffer(size, size);
    }

    public void release(ByteBuf toRelease) {
        toRelease.release();
    }

    public int sizeOf(ByteBuf toMeasure) {
        return toMeasure.readableBytes();
    }

    public ByteBuf concat(ByteBuf left, ByteBuf right) {
        if (!left.isReadable()) {
            return right.duplicate();
        }
        if (!right.isReadable()) {
            return left.duplicate();
        }
        CompositeByteBuf c = this.allocator.compositeBuffer(2);
        c.addComponents(left, right);
        c.writerIndex(left.writerIndex() - left.readerIndex() + right.writerIndex() - right.readerIndex());
        return c;
    }

    public byte readByte(ByteBuf source) {
        return source.readByte();
    }

    public int readInt(ByteBuf source) {
        return source.readInt();
    }

    public InetAddress readInetAddr(ByteBuf source) {
        int length = this.readByte(source) & 0xFF;
        byte[] bytes = new byte[length];
        source.readBytes(bytes);
        return this.newInetAddress(bytes);
    }

    public long readLong(ByteBuf source) {
        return source.readLong();
    }

    public int readUnsignedShort(ByteBuf source) {
        return source.readUnsignedShort();
    }

    public ByteBuffer readBytes(ByteBuf source) {
        int length = this.readInt(source);
        if (length < 0) {
            return null;
        }
        ByteBuf slice = source.readSlice(length);
        return ByteBuffer.wrap(ByteBufPrimitiveCodec.readRawBytes(slice));
    }

    public byte[] readShortBytes(ByteBuf source) {
        try {
            int length = this.readUnsignedShort(source);
            byte[] bytes = new byte[length];
            source.readBytes(bytes);
            return bytes;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Not enough bytes to read a byte array preceded by its 2 bytes length");
        }
    }

    public String readString(ByteBuf source) {
        int length = this.readUnsignedShort(source);
        return ByteBufPrimitiveCodec.readString(source, length);
    }

    public String readLongString(ByteBuf source) {
        int length = this.readInt(source);
        return ByteBufPrimitiveCodec.readString(source, length);
    }

    public void writeByte(byte b, ByteBuf dest) {
        dest.writeByte(b);
    }

    public void writeInt(int i, ByteBuf dest) {
        dest.writeInt(i);
    }

    public void writeInetAddr(InetAddress inetAddr, ByteBuf dest) {
        byte[] bytes = inetAddr.getAddress();
        this.writeByte((byte)bytes.length, dest);
        dest.writeBytes(bytes);
    }

    public void writeLong(long l, ByteBuf dest) {
        dest.writeLong(l);
    }

    public void writeUnsignedShort(int i, ByteBuf dest) {
        dest.writeShort(i);
    }

    public void writeString(String s, ByteBuf dest) {
        byte[] bytes = s.getBytes(CharsetUtil.UTF_8);
        this.writeUnsignedShort(bytes.length, dest);
        dest.writeBytes(bytes);
    }

    public void writeLongString(String s, ByteBuf dest) {
        byte[] bytes = s.getBytes(CharsetUtil.UTF_8);
        this.writeInt(bytes.length, dest);
        dest.writeBytes(bytes);
    }

    public void writeBytes(ByteBuffer bytes, ByteBuf dest) {
        if (bytes == null) {
            this.writeInt(-1, dest);
        } else {
            this.writeInt(bytes.remaining(), dest);
            dest.writeBytes(bytes.duplicate());
        }
    }

    public void writeBytes(byte[] bytes, ByteBuf dest) {
        if (bytes == null) {
            this.writeInt(-1, dest);
        } else {
            this.writeInt(bytes.length, dest);
            dest.writeBytes(bytes);
        }
    }

    public void writeShortBytes(byte[] bytes, ByteBuf dest) {
        this.writeUnsignedShort(bytes.length, dest);
        dest.writeBytes(bytes);
    }

    private static byte[] readRawBytes(ByteBuf buffer) {
        if (buffer.hasArray() && buffer.readableBytes() == buffer.array().length) {
            buffer.readerIndex(buffer.writerIndex());
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        return bytes;
    }

    private static String readString(ByteBuf source, int length) {
        try {
            String str = source.toString(source.readerIndex(), length, CharsetUtil.UTF_8);
            source.readerIndex(source.readerIndex() + length);
            return str;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Not enough bytes to read an UTF-8 serialized string of size " + length, e);
        }
    }

    private InetAddress newInetAddress(byte[] bytes) {
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Invalid address length: %d (%s)", bytes.length, Arrays.toString(bytes)));
        }
    }
}

