/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.json;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.driver.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.datastax.oss.driver.shaded.fasterxml.jackson.databind.JavaType;
import com.datastax.oss.driver.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.datastax.oss.driver.shaded.fasterxml.jackson.databind.type.TypeFactory;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class JsonCodec<T>
implements TypeCodec<T> {
    private final ObjectMapper objectMapper;
    private final GenericType<T> javaType;
    private final JavaType jacksonJavaType;

    public JsonCodec(@NonNull Class<T> javaClass) {
        this(GenericType.of(Objects.requireNonNull(javaClass, "javaClass cannot be null")));
    }

    public JsonCodec(@NonNull GenericType<T> javaType) {
        this(javaType, new ObjectMapper());
    }

    public JsonCodec(@NonNull Class<T> javaClass, @NonNull ObjectMapper objectMapper) {
        this(GenericType.of(Objects.requireNonNull(javaClass, "javaClass cannot be null")), objectMapper);
    }

    public JsonCodec(@NonNull GenericType<T> javaType, @NonNull ObjectMapper objectMapper) {
        this.javaType = Objects.requireNonNull(javaType, "javaType cannot be null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper cannot be null");
        this.jacksonJavaType = TypeFactory.defaultInstance().constructType(javaType.getType());
    }

    @Override
    @NonNull
    public GenericType<T> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.TEXT;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable T value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        try {
            return ByteBuffer.wrap(this.objectMapper.writeValueAsBytes(value));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to encode value as JSON", e);
        }
    }

    @Override
    @Nullable
    public T decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        try {
            return this.objectMapper.readValue(Bytes.getArray((ByteBuffer)bytes), this.jacksonJavaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to decode JSON value", e);
        }
    }

    @Override
    @NonNull
    public String format(@Nullable T value) {
        String json;
        if (value == null) {
            return "NULL";
        }
        try {
            json = this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to format value as JSON", e);
        }
        return Strings.quote(json);
    }

    @Override
    @Nullable
    public T parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!Strings.isQuoted(value)) {
            throw new IllegalArgumentException("JSON strings must be enclosed by single quotes");
        }
        String json = Strings.unquote(value);
        try {
            return this.objectMapper.readValue(json, this.jacksonJavaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse value as JSON", e);
        }
    }
}

