/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.internal.core.metadata.token.CanonicalNodeListBuilder;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationFactor;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategy;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class SimpleReplicationStrategy
implements ReplicationStrategy {
    private final ReplicationFactor replicationFactor;

    SimpleReplicationStrategy(Map<String, String> replicationConfig) {
        this(SimpleReplicationStrategy.extractReplicationFactor(replicationConfig));
    }

    @VisibleForTesting
    SimpleReplicationStrategy(ReplicationFactor replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    @Override
    public Map<Token, List<Node>> computeReplicasListByToken(Map<Token, Node> tokenToPrimary, List<Token> ring) {
        int rf = Math.min(this.replicationFactor.fullReplicas(), ring.size());
        ImmutableMap.Builder result = ImmutableMap.builder();
        CanonicalNodeListBuilder replicasBuilder = new CanonicalNodeListBuilder();
        for (int i = 0; i < ring.size(); ++i) {
            replicasBuilder.clear();
            for (int j = 0; j < ring.size() && replicasBuilder.size() < rf; ++j) {
                replicasBuilder.add(tokenToPrimary.get(SimpleReplicationStrategy.getTokenWrapping(i + j, ring)));
            }
            result.put((Object)ring.get(i), replicasBuilder.build());
        }
        return result.build();
    }

    private static Token getTokenWrapping(int i, List<Token> ring) {
        return ring.get(i % ring.size());
    }

    private static ReplicationFactor extractReplicationFactor(Map<String, String> replicationConfig) {
        String factorString = replicationConfig.get("replication_factor");
        Preconditions.checkNotNull((Object)factorString, (Object)("Missing replication factor in " + replicationConfig));
        return ReplicationFactor.fromString(factorString);
    }
}

