/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
class CanonicalNodeListBuilder {
    private final Map<List<Node>, List<Node>> canonicalLists = new HashMap<List<Node>, List<Node>>();
    private final List<Node> elements = new ArrayList<Node>();

    CanonicalNodeListBuilder() {
    }

    void add(Node node) {
        if (!this.elements.contains(node)) {
            this.elements.add(node);
        }
    }

    int size() {
        return this.elements.size();
    }

    List<Node> build() {
        return this.canonicalLists.computeIfAbsent(this.elements, ImmutableList::copyOf);
    }

    void clear() {
        this.elements.clear();
    }
}

