/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PeerRowValidator {
    public static boolean isValid(@NonNull AdminRow peerRow, boolean allowZeroTokenPeers) {
        boolean hasPeersRpcAddress = !peerRow.isNull("rpc_address");
        boolean hasPeersV2RpcAddress = !peerRow.isNull("native_address") && !peerRow.isNull("native_port");
        boolean hasRpcAddress = hasPeersRpcAddress || hasPeersV2RpcAddress;
        return hasRpcAddress && !peerRow.isNull("host_id") && !peerRow.isNull("data_center") && !peerRow.isNull("rack") && (allowZeroTokenPeers || !peerRow.isNull("tokens")) && !peerRow.isNull("schema_version");
    }

    public static boolean isValid(@NonNull AdminRow peerRow) {
        return PeerRowValidator.isValid(peerRow, false);
    }
}

